/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.projection.AbstractProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeProjectionChoice
extends AbstractProjectionChoice
implements SubPrefsOptions {
    String code;

    public CodeProjectionChoice() {
        super(I18n.tr("By Code (EPSG)", new Object[0]), "core:code");
    }

    @Override
    public Projection getProjection() {
        return Projections.getProjectionByCode(this.code);
    }

    @Override
    public String getCurrentCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectionName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        if (collection != null && !collection.isEmpty()) {
            this.code = collection.iterator().next();
        }
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new CodeSelectionPanel(this.code, actionListener);
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        CodeSelectionPanel codeSelectionPanel = (CodeSelectionPanel)jPanel;
        return Collections.singleton(codeSelectionPanel.getCode());
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        return null;
    }

    @Override
    public boolean showProjectionCode() {
        return true;
    }

    @Override
    public boolean showProjectionName() {
        return true;
    }

    private class CodeSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    DocumentListener {
        public JosmTextField filter;
        private ProjectionCodeListModel model;
        public JList selectionList;
        List<String> data;
        List<String> filteredData;
        final String DEFAULT_CODE = "EPSG:3857";
        String lastCode = "EPSG:3857";
        ActionListener listener;

        public CodeSelectionPanel(String string, ActionListener actionListener) {
            this.listener = actionListener;
            this.data = new ArrayList<String>(Projections.getAllProjectionCodes());
            Collections.sort(this.data, new CodeComparator());
            this.filteredData = new ArrayList<String>(this.data);
            this.build();
            this.setCode(string != null ? string : "EPSG:3857");
            this.selectionList.addListSelectionListener(this);
        }

        private void build() {
            this.filter = new JosmTextField(30);
            this.filter.setColumns(10);
            this.filter.getDocument().addDocumentListener(this);
            this.selectionList = new JList<Object>(this.data.toArray());
            this.model = new ProjectionCodeListModel();
            this.selectionList.setModel(this.model);
            JScrollPane jScrollPane = new JScrollPane(this.selectionList);
            jScrollPane.setPreferredSize(new Dimension(200, 214));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.filter, GBC.eol().weight(1.0, 0.0));
            this.add((Component)jScrollPane, GBC.eol());
        }

        public String getCode() {
            int n = this.selectionList.getSelectedIndex();
            if (n == -1) {
                return this.lastCode;
            }
            return this.filteredData.get(this.selectionList.getSelectedIndex());
        }

        public void setCode(String string) {
            int n = this.filteredData.indexOf(string);
            if (n != -1) {
                this.selectionList.setSelectedIndex(n);
                this.selectionList.ensureIndexIsVisible(n);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.listener.actionPerformed(null);
            this.lastCode = this.getCode();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateFilter();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateFilter();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateFilter();
        }

        private void updateFilter() {
            this.filteredData.clear();
            String string = this.filter.getText().trim().toLowerCase();
            for (String string2 : this.data) {
                if (!string2.toLowerCase().contains(string)) continue;
                this.filteredData.add(string2);
            }
            this.model.fireContentsChanged();
            int n = this.filteredData.indexOf(this.lastCode);
            if (n == -1) {
                this.selectionList.clearSelection();
                if (this.selectionList.getModel().getSize() > 0) {
                    this.selectionList.ensureIndexIsVisible(0);
                }
            } else {
                this.selectionList.setSelectedIndex(n);
                this.selectionList.ensureIndexIsVisible(n);
            }
        }

        private class ProjectionCodeListModel
        extends AbstractListModel {
            private ProjectionCodeListModel() {
            }

            public int getSize() {
                return CodeSelectionPanel.this.filteredData.size();
            }

            public Object getElementAt(int n) {
                if (n >= 0 && n < CodeSelectionPanel.this.filteredData.size()) {
                    return CodeSelectionPanel.this.filteredData.get(n);
                }
                return null;
            }

            public void fireContentsChanged() {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CodeComparator
        implements Comparator<String> {
            final Pattern codePattern = Pattern.compile("([a-zA-Z]+):(\\d+)");

            private CodeComparator() {
            }

            @Override
            public int compare(String string, String string2) {
                Matcher matcher = this.codePattern.matcher(string);
                Matcher matcher2 = this.codePattern.matcher(string2);
                if (matcher.matches()) {
                    if (matcher2.matches()) {
                        int n = matcher.group(1).compareTo(matcher2.group(1));
                        if (n != 0) {
                            return n;
                        }
                        int n2 = Integer.parseInt(matcher.group(2));
                        int n3 = Integer.parseInt(matcher2.group(2));
                        return new Integer(n2).compareTo(n3);
                    }
                    return -1;
                }
                if (matcher2.matches()) {
                    return 1;
                }
                return string.compareTo(string2);
            }
        }
    }
}

