/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.Utils;

public class NodeElemStyle
extends ElemStyle
implements StyleKeys {
    public MapImage mapImage;
    public Symbol symbol;
    public static final NodeElemStyle SIMPLE_NODE_ELEMSTYLE;
    public static final StyleCache.StyleList DEFAULT_NODE_STYLELIST;
    public static final StyleCache.StyleList DEFAULT_NODE_STYLELIST_TEXT;

    protected NodeElemStyle(Cascade cascade, MapImage mapImage, Symbol symbol, float f) {
        super(cascade, f);
        this.mapImage = mapImage;
        this.symbol = symbol;
    }

    public static NodeElemStyle create(Environment environment) {
        return NodeElemStyle.create(environment, 4.0f, false);
    }

    private static NodeElemStyle create(Environment environment, float f, boolean bl) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapImage mapImage = NodeElemStyle.createIcon(environment, ICON_KEYS);
        Symbol symbol = null;
        if (mapImage == null) {
            symbol = NodeElemStyle.createSymbol(environment);
        }
        if (!bl && symbol == null && mapImage == null) {
            return null;
        }
        return new NodeElemStyle(cascade, mapImage, symbol, f);
    }

    public static MapImage createIcon(Environment environment, String[] stringArray) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapPaintStyles.IconReference iconReference = cascade.get(stringArray[0], null, MapPaintStyles.IconReference.class);
        if (iconReference == null) {
            return null;
        }
        Cascade cascade2 = environment.mc.getCascade("default");
        Float f = cascade2.get(stringArray[1], null, Float.class);
        if (f != null && f.floatValue() <= 0.0f) {
            f = null;
        }
        Float f2 = NodeElemStyle.getWidth(cascade, stringArray[1], f);
        Float f3 = cascade2.get(stringArray[2], null, Float.class);
        if (f3 != null && f3.floatValue() <= 0.0f) {
            f3 = null;
        }
        Float f4 = NodeElemStyle.getWidth(cascade, stringArray[2], f3);
        int n = f2 == null ? -1 : Math.round(f2.floatValue());
        int n2 = f4 == null ? -1 : Math.round(f4.floatValue());
        MapImage mapImage = new MapImage(iconReference.iconName, iconReference.source);
        mapImage.width = n;
        mapImage.height = n2;
        mapImage.alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.icon-image-alpha", 255)));
        Integer n3 = Utils.color_float2int(cascade.get(stringArray[3], null, Float.TYPE));
        if (n3 != null) {
            mapImage.alpha = n3;
        }
        return mapImage;
    }

    private static Symbol createSymbol(Environment environment) {
        Float f;
        SymbolShape symbolShape;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        Keyword keyword = cascade.get("symbol-shape", null, Keyword.class);
        if (keyword == null) {
            return null;
        }
        if (Utils.equal(keyword.val, "square")) {
            symbolShape = SymbolShape.SQUARE;
        } else if (Utils.equal(keyword.val, "circle")) {
            symbolShape = SymbolShape.CIRCLE;
        } else if (Utils.equal(keyword.val, "triangle")) {
            symbolShape = SymbolShape.TRIANGLE;
        } else if (Utils.equal(keyword.val, "pentagon")) {
            symbolShape = SymbolShape.PENTAGON;
        } else if (Utils.equal(keyword.val, "hexagon")) {
            symbolShape = SymbolShape.HEXAGON;
        } else if (Utils.equal(keyword.val, "heptagon")) {
            symbolShape = SymbolShape.HEPTAGON;
        } else if (Utils.equal(keyword.val, "octagon")) {
            symbolShape = SymbolShape.OCTAGON;
        } else if (Utils.equal(keyword.val, "nonagon")) {
            symbolShape = SymbolShape.NONAGON;
        } else if (Utils.equal(keyword.val, "decagon")) {
            symbolShape = SymbolShape.DECAGON;
        } else {
            return null;
        }
        Float f2 = cascade2.get("symbol-size", null, Float.class);
        if (f2 != null && f2.floatValue() <= 0.0f) {
            f2 = null;
        }
        if ((f = NodeElemStyle.getWidth(cascade, "symbol-size", f2)) == null) {
            f = Float.valueOf(10.0f);
        }
        if (f.floatValue() <= 0.0f) {
            return null;
        }
        Float f3 = NodeElemStyle.getWidth(cascade2, "symbol-stroke-width", null);
        Float f4 = NodeElemStyle.getWidth(cascade, "symbol-stroke-width", f3);
        Color color = cascade.get("symbol-stroke-color", null, Color.class);
        if (f4 == null && color != null) {
            f4 = Float.valueOf(1.0f);
        } else if (f4 != null && color == null) {
            color = Color.ORANGE;
        }
        BasicStroke basicStroke = null;
        if (color != null) {
            float f5 = cascade.get("symbol-stroke-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Utils.color_float2int(Float.valueOf(f5)));
            basicStroke = new BasicStroke(f4.floatValue());
        }
        Color color2 = cascade.get("symbol-fill-color", null, Color.class);
        if (basicStroke == null && color2 == null) {
            color2 = Color.BLUE;
        }
        if (color2 != null) {
            float f6 = cascade.get("symbol-fill-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Utils.color_float2int(Float.valueOf(f6)));
        }
        return new Symbol(symbolShape, Math.round(f.floatValue()), basicStroke, color, color2);
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Node) {
            Node node = (Node)osmPrimitive;
            if (this.mapImage != null && styledMapRenderer.isShowIcons()) {
                styledMapRenderer.drawNodeIcon(node, styledMapRenderer.isInactiveMode() || node.isDisabled() ? this.mapImage.getDisabled() : this.mapImage.getImage(), Utils.color_int2float(this.mapImage.alpha).floatValue(), bl, bl2);
            } else if (this.symbol != null) {
                Color color;
                Color color2 = this.symbol.fillColor;
                if (color2 != null) {
                    if (styledMapRenderer.isInactiveMode() || node.isDisabled()) {
                        color2 = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color2 = mapPaintSettings.getSelectedColor(color2.getAlpha());
                    } else if (bl2) {
                        color2 = mapPaintSettings.getRelationSelectedColor(color2.getAlpha());
                    }
                }
                if ((color = this.symbol.strokeColor) != null) {
                    if (styledMapRenderer.isInactiveMode() || node.isDisabled()) {
                        color = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color = mapPaintSettings.getSelectedColor(color.getAlpha());
                    } else if (bl2) {
                        color = mapPaintSettings.getRelationSelectedColor(color.getAlpha());
                    }
                }
                styledMapRenderer.drawNodeSymbol(node, this.symbol, color2, color);
            } else {
                boolean bl3 = node.isConnectionNode();
                Color color = styledMapRenderer.isInactiveMode() || node.isDisabled() ? mapPaintSettings.getInactiveColor() : (bl ? mapPaintSettings.getSelectedColor() : (bl2 ? mapPaintSettings.getRelationSelectedColor() : (bl3 ? (node.isTagged() ? mapPaintSettings.getTaggedConnectionColor() : mapPaintSettings.getConnectionColor()) : (node.isTagged() ? mapPaintSettings.getTaggedColor() : mapPaintSettings.getNodeColor()))));
                int n = Utils.max(bl ? mapPaintSettings.getSelectedNodeSize() : 0, node.isTagged() ? mapPaintSettings.getTaggedNodeSize() : 0, bl3 ? mapPaintSettings.getConnectionNodeSize() : 0, mapPaintSettings.getUnselectedNodeSize());
                boolean bl4 = bl && mapPaintSettings.isFillSelectedNode() || node.isTagged() && mapPaintSettings.isFillTaggedNode() || bl3 && mapPaintSettings.isFillConnectionNode() || mapPaintSettings.isFillUnselectedNode();
                styledMapRenderer.drawNode(node, color, n, bl4);
            }
        } else if (osmPrimitive instanceof Relation && this.mapImage != null) {
            styledMapRenderer.drawRestriction((Relation)osmPrimitive, this.mapImage);
        }
    }

    public BoxTextElemStyle.BoxProvider getBoxProvider() {
        if (this.mapImage != null) {
            return this.mapImage.getBoxProvider();
        }
        if (this.symbol != null) {
            return new BoxTextElemStyle.SimpleBoxProvider(new Rectangle(-this.symbol.size / 2, -this.symbol.size / 2, this.symbol.size, this.symbol.size));
        }
        int n = Utils.max(Main.pref.getInteger("mappaint.node.selected-size", 5), Main.pref.getInteger("mappaint.node.unselected-size", 3), Main.pref.getInteger("mappaint.node.connection-size", 5), Main.pref.getInteger("mappaint.node.tagged-size", 3));
        return new BoxTextElemStyle.SimpleBoxProvider(new Rectangle(-n / 2, -n / 2, n, n));
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 17 * n + (this.mapImage != null ? this.mapImage.hashCode() : 0);
        n = 17 * n + (this.symbol != null ? this.symbol.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NodeElemStyle nodeElemStyle = (NodeElemStyle)object;
        if (!Utils.equal(this.mapImage, nodeElemStyle.mapImage)) {
            return false;
        }
        return Utils.equal(this.symbol, nodeElemStyle.symbol);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NodeElemStyle{");
        stringBuilder.append(super.toString());
        if (this.mapImage != null) {
            stringBuilder.append(" icon=[" + this.mapImage + "]");
        }
        if (this.symbol != null) {
            stringBuilder.append(" symbol=[" + this.symbol + "]");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        SIMPLE_NODE_ELEMSTYLE = NodeElemStyle.create(new Environment(null, multiCascade, "default", null), 4.1f, true);
        if (SIMPLE_NODE_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        DEFAULT_NODE_STYLELIST = new StyleCache.StyleList(SIMPLE_NODE_ELEMSTYLE);
        DEFAULT_NODE_STYLELIST_TEXT = new StyleCache.StyleList(SIMPLE_NODE_ELEMSTYLE, BoxTextElemStyle.SIMPLE_NODE_TEXT_ELEMSTYLE);
    }

    public static class Symbol {
        public SymbolShape symbol;
        public int size;
        public Stroke stroke;
        public Color strokeColor;
        public Color fillColor;

        public Symbol(SymbolShape symbolShape, int n, Stroke stroke, Color color, Color color2) {
            if (stroke != null && color == null) {
                throw new IllegalArgumentException();
            }
            if (stroke == null && color2 == null) {
                throw new IllegalArgumentException();
            }
            this.symbol = symbolShape;
            this.size = n;
            this.stroke = stroke;
            this.strokeColor = color;
            this.fillColor = color2;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)object;
            return this.symbol == symbol.symbol && this.size == symbol.size && Utils.equal(this.stroke, symbol.stroke) && Utils.equal(this.strokeColor, symbol.strokeColor) && Utils.equal(this.fillColor, symbol.fillColor);
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + this.symbol.hashCode();
            n = 67 * n + this.size;
            n = 67 * n + (this.stroke != null ? this.stroke.hashCode() : 0);
            n = 67 * n + (this.strokeColor != null ? this.strokeColor.hashCode() : 0);
            n = 67 * n + (this.fillColor != null ? this.fillColor.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "symbol=" + (Object)((Object)this.symbol) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolShape {
        SQUARE,
        CIRCLE,
        TRIANGLE,
        PENTAGON,
        HEXAGON,
        HEPTAGON,
        OCTAGON,
        NONAGON,
        DECAGON;

    }
}

