/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadPrimitivesTask
extends PleaseWaitRunnable {
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private final List<PrimitiveId> ids;
    private Set<PrimitiveId> missingPrimitives;
    private final OsmDataLayer layer;
    private final boolean fullRelation;
    private MultiFetchServerObjectReader multiObjectReader;
    private OsmServerObjectReader objectReader;

    public DownloadPrimitivesTask(OsmDataLayer osmDataLayer, List<PrimitiveId> list, boolean bl) throws IllegalArgumentException {
        super(I18n.tr("Download objects", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.ids = list;
        this.layer = osmDataLayer;
        this.fullRelation = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadPrimitivesTask downloadPrimitivesTask = this;
        synchronized (downloadPrimitivesTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        GuiHelper.runInEDTAndWait(new Runnable(){

            public void run() {
                DownloadPrimitivesTask.this.layer.mergeFrom(DownloadPrimitivesTask.this.ds);
                AutoScaleAction.zoomTo(DownloadPrimitivesTask.this.ds.allPrimitives());
                DownloadPrimitivesTask.this.layer.onPostDownloadFromServer();
            }
        });
    }

    protected void initMultiFetchReader(MultiFetchServerObjectReader multiFetchServerObjectReader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to download ...", new Object[0]));
        for (PrimitiveId primitiveId : this.ids) {
            OsmPrimitive osmPrimitive = this.layer.data.getPrimitiveById(primitiveId);
            if (osmPrimitive == null) {
                switch (primitiveId.getType()) {
                    case NODE: {
                        osmPrimitive = new Node(primitiveId.getUniqueId());
                        break;
                    }
                    case WAY: {
                        osmPrimitive = new Way(primitiveId.getUniqueId());
                        break;
                    }
                    case RELATION: {
                        osmPrimitive = new Relation(primitiveId.getUniqueId());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            multiFetchServerObjectReader.append(osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            DownloadPrimitivesTask downloadPrimitivesTask;
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = new MultiFetchServerObjectReader();
            }
            this.initMultiFetchReader(this.multiObjectReader);
            DataSet dataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            this.missingPrimitives = this.multiObjectReader.getMissingPrimitives();
            object = this;
            synchronized (object) {
                this.multiObjectReader = null;
            }
            object = new DataSetMerger(this.ds, dataSet);
            ((DataSetMerger)object).merge();
            for (Relation osmPrimitive : this.ds.getRelations()) {
                if (this.canceled) {
                    return;
                }
                if (!osmPrimitive.hasIncompleteMembers()) continue;
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(osmPrimitive.getId(), OsmPrimitiveType.RELATION, this.fullRelation);
                }
                dataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    this.objectReader = null;
                }
                object = new DataSetMerger(this.ds, dataSet);
                ((DataSetMerger)object).merge();
            }
            for (Way way : this.ds.getWays()) {
                if (this.canceled) {
                    return;
                }
                if (!way.hasIncompleteNodes()) continue;
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(way.getId(), OsmPrimitiveType.WAY, true);
                }
                dataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    this.objectReader = null;
                }
                object = new DataSetMerger(this.ds, dataSet);
                ((DataSetMerger)object).merge();
            }
        }
        catch (Exception exception) {
            if (this.canceled) {
                return;
            }
            this.lastException = exception;
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

