/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

class RelationSortUtils {
    RelationSortUtils() {
    }

    static WayConnectionType.Direction roundaboutType(RelationMember relationMember) {
        if (relationMember == null || !relationMember.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        Way way = relationMember.getWay();
        return RelationSortUtils.roundaboutType(way);
    }

    static WayConnectionType.Direction roundaboutType(Way way) {
        if (way != null && "roundabout".equals(way.get("junction")) && way.getNodesCount() < 200 && way.getNodesCount() > 2 && way.getNode(0) != null && way.getNode(1) != null && way.getNode(2) != null && way.firstNode() == way.lastNode()) {
            EastNorth eastNorth = way.getNode(0).getEastNorth();
            EastNorth eastNorth2 = way.getNode(1).getEastNorth();
            EastNorth eastNorth3 = way.getNode(2).getEastNorth();
            if (eastNorth != null && eastNorth2 != null && eastNorth3 != null) {
                eastNorth = eastNorth.sub(eastNorth2);
                eastNorth2 = eastNorth2.sub(eastNorth3);
                return eastNorth.north() * eastNorth2.east() - eastNorth2.north() * eastNorth.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
            }
        }
        return WayConnectionType.Direction.NONE;
    }

    static boolean isBackward(RelationMember relationMember) {
        return relationMember.getRole().equals("backward");
    }

    static boolean isForward(RelationMember relationMember) {
        return relationMember.getRole().equals("forward");
    }

    static boolean isOneway(RelationMember relationMember) {
        return RelationSortUtils.isForward(relationMember) || RelationSortUtils.isBackward(relationMember);
    }
}

