/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableLinkedCellRenderer
extends MemberTableCellRenderer {
    static final Image arrowUp = ImageProvider.get("dialogs/relation", "arrowup").getImage();
    static final Image arrowDown = ImageProvider.get("dialogs/relation", "arrowdown").getImage();
    static final Image corners = ImageProvider.get("dialogs/relation", "roundedcorners").getImage();
    static final Image roundabout_right = ImageProvider.get("dialogs/relation", "roundabout_right_tiny").getImage();
    static final Image roundabout_left = ImageProvider.get("dialogs/relation", "roundabout_left_tiny").getImage();
    private WayConnectionType value = new WayConnectionType();

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        if (object == null) {
            return this;
        }
        this.value = (WayConnectionType)object;
        this.renderForeground(bl);
        this.setToolTipText(((WayConnectionType)object).getToolTip());
        this.renderBackground(this.getModel(jTable), null, bl);
        return this;
    }

    public void paintComponent(Graphics graphics) {
        int[] nArray;
        Object object;
        super.paintComponent(graphics);
        if (this.value == null || !this.value.isValid()) {
            return;
        }
        int n = this.getSize().height - 1;
        int n2 = 10;
        int n3 = 0;
        if (this.value.isOnewayLoopForwardPart) {
            n3 = -3;
        }
        if (this.value.isOnewayLoopBackwardPart) {
            n3 = 3;
        }
        int n4 = this.getSize().width / 2;
        if (this.value.isLoop) {
            n4 -= n2 / 2 - 1;
        }
        int n5 = 2;
        int n6 = 2 + n5 + 1;
        int n7 = 0;
        int n8 = 0;
        if (this.value.linkPrev) {
            graphics.setColor(Color.black);
            if (this.value.isOnewayHead) {
                graphics.fillRect(n4 - 1, 0, 3, 1);
            } else {
                graphics.fillRect(n4 - 1 + n3, 0, 3, 1);
            }
            n7 = 0;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n7 = 5;
            graphics.drawImage(corners, n4, n7 - 3, n4 + 3, n7, 0, 0, 3, 3, new Color(0, 0, 0, 0), null);
            graphics.drawImage(corners, n4 + n2 - 2, n7 - 3, n4 + n2 + 1, n7, 2, 0, 5, 3, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n4 + 3, n7 - 3, n4 + n2 - 3, n7 - 3);
        } else {
            graphics.setColor(Color.red);
            if (this.value.isOnewayHead) {
                graphics.drawRect(n4 - 1, n6 - 3 - n5, n5, n5);
            } else {
                graphics.drawRect(n4 - 1 + n3, n6 - 1 - n5, n5, n5);
            }
            n7 = n6;
        }
        if (this.value.linkNext) {
            graphics.setColor(Color.black);
            if (this.value.isOnewayTail) {
                graphics.fillRect(n4 - 1, n, 3, 1);
            } else {
                graphics.fillRect(n4 - 1 + n3, n, 3, 1);
            }
            n8 = n;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n8 = n - 5;
            graphics.fillRect(n4 - 1, n8 + 2, 3, 3);
            graphics.drawLine(n4, n8, n4, n8 + 2);
            graphics.drawImage(corners, n4 + n2 - 2, n8 + 1, n4 + n2 + 1, n8 + 4, 2, 2, 5, 5, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n4 + 3 - 1, n8 + 3, n4 + n2 - 3, n8 + 3);
        } else {
            graphics.setColor(Color.red);
            if (this.value.isOnewayTail) {
                graphics.drawRect(n4 - 1, n - n6 + 3, n5, n5);
            } else {
                graphics.drawRect(n4 - 1 + n3, n - n6 + 1, n5, n5);
            }
            n8 = n - n6;
        }
        graphics.setColor(Color.black);
        if (this.value.isLoop) {
            graphics.drawLine(n4 + n2, n7, n4 + n2, n8);
        }
        if (this.value.isOnewayHead) {
            this.setDotted(graphics);
            n7 = 7;
            object = new int[]{n4 - n3 + 1, n4 - n3 + 1, n4};
            nArray = new int[]{n, n7 + 1, 1};
            graphics.drawPolyline((int[])object, nArray, 3);
            this.unsetDotted(graphics);
            graphics.drawLine(n4 + n3, n7 + 1, n4, 1);
        }
        if (this.value.isOnewayTail) {
            this.setDotted(graphics);
            n8 = n - 7;
            object = new int[]{n4 + 1, n4 - n3 + 1, n4 - n3 + 1};
            nArray = new int[]{n - 1, n8, n7};
            graphics.drawPolyline((int[])object, nArray, 3);
            this.unsetDotted(graphics);
            graphics.drawLine(n4 + n3, n8, n4, n - 1);
        }
        if ((this.value.isOnewayLoopForwardPart || this.value.isOnewayLoopBackwardPart) && !this.value.isOnewayTail && !this.value.isOnewayHead) {
            this.setDotted(graphics);
            graphics.drawLine(n4 - n3 + 1, n7, n4 - n3 + 1, n8 + 1);
            this.unsetDotted(graphics);
        }
        if (!this.value.isOnewayLoopForwardPart && !this.value.isOnewayLoopBackwardPart) {
            graphics.drawLine(n4, n7, n4, n8);
        }
        graphics.drawLine(n4 + n3, n7, n4 + n3, n8);
        object = null;
        switch (this.value.direction) {
            case FORWARD: {
                object = arrowDown;
                break;
            }
            case BACKWARD: {
                object = arrowUp;
            }
        }
        if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_LEFT) {
            graphics.drawImage(roundabout_left, n4 - 6, 1, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_RIGHT) {
            graphics.drawImage(roundabout_right, n4 - 6, 1, null);
        }
        if (!this.value.isOnewayLoopForwardPart && !this.value.isOnewayLoopBackwardPart && object != null) {
            graphics.drawImage((Image)object, n4 - 3, (n7 + n8) / 2 - 2, null);
        }
        if (this.value.isOnewayLoopBackwardPart && this.value.isOnewayLoopForwardPart) {
            if (object == arrowDown) {
                object = arrowUp;
            } else if (object == arrowUp) {
                object = arrowDown;
            }
        }
        if (object != null) {
            graphics.drawImage((Image)object, n4 + n3 - 3, (n7 + n8) / 2 - 2, null);
        }
    }

    private void setDotted(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{1.0f, 2.0f}, 0.0f));
    }

    private void unsetDotted(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(new BasicStroke());
    }
}

