/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test
extends AbstractVisitor {
    protected final String name;
    protected final String description;
    public boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    public boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>(30);
    protected boolean partialSelection;
    protected ProgressMonitor progressMonitor;

    public Test(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public Test(String string) {
        this(string, null);
    }

    public void initialize() throws Exception {
    }

    public void startTest(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        this.progressMonitor.beginTask(I18n.tr("Running test {0}", this.name));
        this.errors = new ArrayList<TestError>(30);
    }

    public void setPartialSelection(boolean bl) {
        this.partialSelection = bl;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
        this.progressMonitor.finishTask();
        this.progressMonitor = null;
    }

    public void visit(Collection<OsmPrimitive> collection) {
        this.progressMonitor.setTicksCount(collection.size());
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isUsable()) {
                osmPrimitive.visit(this);
            }
            this.progressMonitor.worked(1);
        }
    }

    @Override
    public void visit(Node node) {
    }

    @Override
    public void visit(Way way) {
    }

    @Override
    public void visit(Relation relation) {
    }

    public void addGui(JPanel jPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        jPanel.add((Component)this.checkEnabled, GBC.std());
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        jPanel.add((Component)this.checkBeforeUpload, gBC);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean bl) {
        this.isBeforeUpload = bl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    protected final Command deletePrimitivesIfNeeded(Collection<? extends OsmPrimitive> collection) {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isDeleted()) continue;
            arrayList.add(osmPrimitive);
        }
        if (!arrayList.isEmpty()) {
            return DeleteCommand.delete(Main.map.mapView.getEditLayer(), arrayList);
        }
        return null;
    }

    protected static final boolean isBuilding(OsmPrimitive osmPrimitive) {
        String string = osmPrimitive.get("building");
        return string != null && !string.equals("no") && !string.equals("entrance");
    }
}

