/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.AbstractProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedProperty<T>
extends AbstractProperty<T>
implements Preferences.PreferenceChangedListener {
    private final String defaultValueAsString;
    private T value;
    private int updateCount;

    protected CachedProperty(String string, String string2) {
        super(string, null);
        Main.pref.addPreferenceChangeListener(this);
        this.defaultValueAsString = string2;
        this.updateValue();
    }

    protected void updateValue() {
        this.value = !Main.pref.get(this.key).isEmpty() ? this.fromString(Main.pref.get(this.key)) : this.getDefaultValue();
        ++this.updateCount;
    }

    protected abstract T fromString(String var1);

    @Override
    public T get() {
        return this.value;
    }

    public void put(String string) {
        Main.pref.put(this.key, string);
        this.value = this.fromString(string);
        ++this.updateCount;
    }

    @Override
    public final boolean put(T t) {
        throw new IllegalAccessError("You cannot use put(T). Use put(String) instead.");
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public T getDefaultValue() {
        return this.fromString(this.getDefaultValueAsString());
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public String getAsString() {
        return Main.pref.get(this.getKey(), this.getDefaultValueAsString());
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(this.key)) {
            this.updateValue();
        }
    }
}

