/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRelationAction
extends AbstractRelationAction {
    public EditRelationAction() {
        this.putValue("Name", I18n.tr("Edit", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Call relation editor for selected relation", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
    }

    public static Set<RelationMember> getMembersForCurrentSelection(Relation relation) {
        OsmDataLayer osmDataLayer;
        HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
        if (Main.map != null && Main.map.mapView != null && (osmDataLayer = Main.map.mapView.getEditLayer()) != null && osmDataLayer.data != null) {
            Collection<OsmPrimitive> collection = osmDataLayer.data.getSelected();
            for (RelationMember relationMember : relation.getMembers()) {
                if (!collection.contains(relationMember.getMember())) continue;
                hashSet.add(relationMember);
            }
        }
        return hashSet;
    }

    public static void launchEditor(Relation relation) {
        if (relation == null || Main.map == null || Main.map.mapView == null) {
            return;
        }
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, EditRelationAction.getMembersForCurrentSelection(relation)).setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.size() != 1) {
            return;
        }
        EditRelationAction.launchEditor((Relation)this.relations.iterator().next());
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.relations.size() == 1);
    }
}

