/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadMembersAction
extends AbstractRelationAction {
    public DownloadMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download all members of the selected relations", new Object[0]));
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "downloadincomplete"));
        this.putValue("help", HelpUtil.ht("/Dialog/RelationList#DownloadMembers"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.isEmpty() || Main.map == null || Main.map.mapView == null) {
            return;
        }
        Main.worker.submit(new DownloadRelationTask(this.relations, Main.map.mapView.getEditLayer()));
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> collection) {
        this.relations = Utils.filter(DownloadMembersAction.getRelations(collection), new Predicate<Relation>(){

            @Override
            public boolean evaluate(Relation relation) {
                return !relation.isNew();
            }
        });
        this.updateEnabledState();
    }
}

