/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;

public class SessionLoadAction
extends DiskAccessAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionLoad"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("jos,joz", "jos", I18n.tr("Session file (*.jos, *.joz)", new Object[0]));
        JFileChooser jFileChooser = SessionLoadAction.createAndOpenFileChooser(true, false, I18n.tr("Open session", new Object[0]), Arrays.asList(extensionFileFilter, FileFilterAllFiles.getInstance()), extensionFileFilter, 0, "lastDirectory");
        if (jFileChooser == null) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        boolean bl = file.getName().toLowerCase().endsWith(".joz");
        Main.worker.submit(new Loader(file, bl));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private boolean zip;
        private List<Layer> layers;
        private List<Runnable> postLoadTasks;
        private NavigatableComponent.ViewportData viewport;

        public Loader(File file, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            this.file = file;
            this.zip = bl;
        }

        protected void cancel() {
            Thread.dumpStack();
            this.canceled = true;
        }

        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (Loader.this.canceled) {
                        return;
                    }
                    if (!Loader.this.layers.isEmpty()) {
                        boolean bl;
                        Layer layer = (Layer)Loader.this.layers.iterator().next();
                        boolean bl2 = bl = Main.map == null;
                        if (bl) {
                            Main.main.createMapFrame(layer, Loader.this.viewport);
                        }
                        for (Layer layer2 : Loader.this.layers) {
                            if (Loader.this.canceled) {
                                return;
                            }
                            Main.main.addLayer(layer2);
                        }
                        if (bl) {
                            Main.map.setVisible(true);
                        }
                    }
                    for (Runnable runnable : Loader.this.postLoadTasks) {
                        if (Loader.this.canceled) {
                            return;
                        }
                        if (runnable == null) continue;
                        runnable.run();
                    }
                }
            });
        }

        protected void realRun() {
            try {
                ProgressMonitor progressMonitor = this.getProgressMonitor();
                SessionReader sessionReader = new SessionReader();
                sessionReader.loadSession(this.file, this.zip, progressMonitor);
                this.layers = sessionReader.getLayers();
                this.postLoadTasks = sessionReader.getPostLoadTasks();
                this.viewport = sessionReader.getViewport();
            }
            catch (IllegalDataException illegalDataException) {
                illegalDataException.printStackTrace();
                HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.file.getName(), illegalDataException.getMessage()), I18n.tr("Data Error", new Object[0]), 0, null);
                this.cancel();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.file.getName(), iOException.getMessage()), I18n.tr("IO Error", new Object[0]), 0, null);
                this.cancel();
            }
            catch (RuntimeException runtimeException) {
                this.cancel();
                throw runtimeException;
            }
            catch (Error error) {
                this.cancel();
                throw error;
            }
        }
    }
}

