/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

public class RestartAction
extends JosmAction {
    public RestartAction() {
        super(I18n.tr("Restart", new Object[0]), "restart", I18n.tr("Restart the application.", new Object[0]), Shortcut.registerShortcut("file:restart", I18n.tr("File: {0}", I18n.tr("Restart", new Object[0])), 74, 5010), false);
        this.putValue("help", HelpUtil.ht("/Action/Restart"));
        this.putValue("toolbar", "action/restart");
        Main.toolbar.register(this);
        this.setEnabled(RestartAction.isRestartSupported());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            RestartAction.restartJOSM();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isRestartSupported() {
        return System.getProperty("sun.java.command") != null;
    }

    public static void restartJOSM() throws IOException {
        if (RestartAction.isRestartSupported() && !Main.exitJosm(false)) {
            return;
        }
        try {
            String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + (Main.platform instanceof PlatformHookWindows ? "java.exe" : "java");
            if (!new File(string).isFile()) {
                throw new IOException("Unable to find suitable java runtime at " + string);
            }
            final ArrayList<String> arrayList = new ArrayList<String>(Collections.singleton(string));
            for (String string2 : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (string2.contains("-agentlib")) continue;
                arrayList.add(string2);
            }
            String[] stringArray = System.getProperty("sun.java.command").split(" ");
            if (stringArray[0].endsWith(".jar")) {
                arrayList.add("-jar");
                arrayList.add(new File(stringArray[0]).getPath());
            } else {
                arrayList.add("-cp");
                arrayList.add("\"" + System.getProperty("java.class.path") + "\"");
                arrayList.add(stringArray[0]);
            }
            arrayList.addAll(Arrays.asList(Main.commandLineArgs));
            Main.info("Restart " + arrayList);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Runtime.getRuntime().exec(arrayList.toArray(new String[0]));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            System.exit(0);
        }
        catch (Exception exception) {
            throw new IOException("Error while trying to restart the application", exception);
        }
    }

    public static HelpAwareOptionPane.ButtonSpec getRestartButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Restart", new Object[0]), ImageProvider.get("restart"), I18n.tr("Restart the application.", new Object[0]), HelpUtil.ht("/Action/Restart"), RestartAction.isRestartSupported());
    }

    public static HelpAwareOptionPane.ButtonSpec getCancelButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to restart later.", new Object[0]), null);
    }

    public static HelpAwareOptionPane.ButtonSpec[] getButtonSpecs() {
        return new HelpAwareOptionPane.ButtonSpec[]{RestartAction.getRestartButtonSpec(), RestartAction.getCancelButtonSpec()};
    }
}

