/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected Shortcut sc;
    private LayerChangeAdapter layerChangeAdapter;
    private SelectionChangeAdapter selectionChangeAdapter;

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut", new Object[0]), 65535, 5000);
        }
        return this.sc;
    }

    public JosmAction(String string, Icon icon, String string2, Shortcut shortcut, boolean bl, String string3, boolean bl2) {
        super(string, icon);
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null) {
            Main.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(string2);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", string3);
        }
        if (bl) {
            Main.toolbar.register(this);
        }
        if (bl2) {
            this.installAdapters();
        }
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        this(string, string2 == null ? null : ImageProvider.get(string2), string3, shortcut, bl, string4 == null ? string2 : string4, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, boolean bl2) {
        this(string, string2, string3, shortcut, bl, null, bl2);
    }

    public JosmAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        this(string, string2, string3, shortcut, bl, null, true);
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean bl) {
        this.setHelpId();
        if (bl) {
            this.installAdapters();
        }
    }

    @Override
    public void destroy() {
        if (this.sc != null) {
            Main.unregisterActionShortcut(this);
        }
        MapView.removeLayerChangeListener(this.layerChangeAdapter);
        DataSet.removeSelectionListener(this.selectionChangeAdapter);
    }

    private void setHelpId() {
        String string = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        this.putValue("help", string);
    }

    public void setTooltip(String string) {
        if (string != null) {
            this.putValue("ShortDescription", Main.platform.makeTooltip(string, this.sc));
        }
    }

    protected static OsmDataLayer getEditLayer() {
        return Main.main.getEditLayer();
    }

    protected static DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    protected void installAdapters() {
        this.layerChangeAdapter = new LayerChangeAdapter();
        this.selectionChangeAdapter = new SelectionChangeAdapter();
        MapView.addLayerChangeListener(this.layerChangeAdapter);
        DataSet.addSelectionListener(this.selectionChangeAdapter);
        this.initEnabledState();
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectionChangeAdapter
    implements SelectionChangedListener {
        private SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            JosmAction.this.updateEnabledState(collection);
        }
    }

    private class LayerChangeAdapter
    implements MapView.LayerChangeListener {
        private LayerChangeAdapter() {
        }

        private void updateEnabledStateInEDT() {
            GuiHelper.runInEDT(new Runnable(){

                public void run() {
                    JosmAction.this.updateEnabledState();
                }
            });
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledStateInEDT();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledStateInEDT();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledStateInEDT();
        }
    }
}

