/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener,
AWTEventListener {
    static ImageryOffsetDialog offsetDialog;
    static Cursor cursor;
    double oldDx;
    double oldDy;
    boolean mouseDown;
    EastNorth prevEastNorth;
    private ImageryLayer layer;
    private MapMode oldMapMode;

    public ImageryAdjustAction(ImageryLayer imageryLayer) {
        super(I18n.tr("New offset", new Object[0]), "adjustimg", I18n.tr("Adjust the position of this imagery layer", new Object[0]), Main.map, cursor);
        this.putValue("toolbar", false);
        this.layer = imageryLayer;
    }

    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        this.oldDx = this.layer.getDx();
        this.oldDy = this.layer.getDy();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        offsetDialog = new ImageryOffsetDialog();
        offsetDialog.setVisible(true);
    }

    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            this.layer.setOffset(this.oldDx, this.oldDy);
            offsetDialog.setVisible(false);
            offsetDialog = null;
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        if (aWTEvent.getID() != 401) {
            return;
        }
        if (this.layer == null) {
            return;
        }
        if (offsetDialog != null && offsetDialog.areFieldsInFocus()) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        double d = 0.0;
        double d2 = 0.0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                d2 = 1.0;
                break;
            }
            case 40: {
                d2 = -1.0;
                break;
            }
            case 37: {
                d = -1.0;
                break;
            }
            case 39: {
                d = 1.0;
            }
        }
        if (d != 0.0 || d2 != 0.0) {
            double d3 = this.layer.getPPD();
            this.layer.displace(d / d3, d2 / d3);
            if (offsetDialog != null) {
                offsetDialog.updateOffset();
            }
            keyEvent.consume();
            Main.map.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.requestFocusInMapView();
            this.prevEastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            Main.map.mapView.setNewCursor(13, (Object)this);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        double d = this.layer.getDx() + eastNorth.east() - this.prevEastNorth.east();
        double d2 = this.layer.getDy() + eastNorth.north() - this.prevEastNorth.north();
        this.layer.setOffset(d, d2);
        if (offsetDialog != null) {
            offsetDialog.updateOffset();
        }
        Main.map.repaint();
        this.prevEastNorth = eastNorth;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Main.map.mapView.repaint();
        Main.map.mapView.resetCursor(this);
        this.prevEastNorth = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (offsetDialog != null || this.layer == null || Main.map == null) {
            return;
        }
        this.oldMapMode = Main.map.mapMode;
        super.actionPerformed(actionEvent);
    }

    static {
        cursor = ImageProvider.getCursor("normal", "move");
    }

    class ImageryOffsetDialog
    extends ExtendedDialog
    implements FocusListener {
        public final JosmTextField tOffset;
        JosmTextField tBookmarkName;
        private boolean ignoreListener;

        public ImageryOffsetDialog() {
            super(Main.parent, I18n.tr("Adjust imagery offset", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.tOffset = new JosmTextField();
            this.tBookmarkName = new JosmTextField();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.contentInsets = new Insets(10, 15, 5, 15);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JMultilineLabel(I18n.tr("Use arrow keys or drag the imagery layer with mouse to adjust the imagery offset.\nYou can also enter east and north offset in the {0} coordinates.\nIf you want to save the offset as bookmark, enter the bookmark name below", ((Object)Main.getProjection()).toString())), GBC.eop());
            jPanel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0])), GBC.std());
            jPanel.add((Component)this.tOffset, GBC.eol().fill(2).insets(0, 0, 0, 5));
            jPanel.add((Component)new JLabel(I18n.tr("Bookmark name: ", new Object[0])), GBC.std());
            jPanel.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.tOffset.setColumns(16);
            this.updateOffsetIntl();
            this.tOffset.addFocusListener(this);
            this.setContent(jPanel);
            this.setupDialog();
        }

        public boolean areFieldsInFocus() {
            return this.tOffset.hasFocus();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.ignoreListener) {
                return;
            }
            String string = this.tOffset.getText();
            int n = string.indexOf(59);
            if (n >= 0 && n + 1 < string.length()) {
                try {
                    String string2 = string.substring(0, n).trim().replace(',', '.');
                    String string3 = string.substring(n + 1).trim().replace(',', '.');
                    double d = Double.parseDouble(string2);
                    double d2 = Double.parseDouble(string3);
                    ImageryAdjustAction.this.layer.setOffset(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.updateOffsetIntl();
            if (Main.isDisplayingMapView()) {
                Main.map.repaint();
            }
        }

        public void updateOffset() {
            this.ignoreListener = true;
            this.updateOffsetIntl();
            this.ignoreListener = false;
        }

        public void updateOffsetIntl() {
            int n = Main.getProjection().getDefaultZoomInPPD() >= 1.0 ? 2 : 7;
            this.tOffset.setText(new Formatter(Locale.US).format("%1." + n + "f; %1." + n + "f", ImageryAdjustAction.this.layer.getDx(), ImageryAdjustAction.this.layer.getDy()).toString());
        }

        private boolean confirmOverwriteBookmark() {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    this.contentInsets = new Insets(10, 15, 10, 15);
                }
            };
            extendedDialog.setContent(I18n.tr("Offset bookmark already exists. Overwrite?", new Object[0]));
            extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
            extendedDialog.setupDialog();
            extendedDialog.setVisible(true);
            return extendedDialog.getValue() == 1;
        }

        protected void buttonAction(int n, ActionEvent actionEvent) {
            if (n == 0 && this.tBookmarkName.getText() != null && !"".equals(this.tBookmarkName.getText()) && OffsetBookmark.getBookmarkByName(ImageryAdjustAction.this.layer, this.tBookmarkName.getText()) != null && !this.confirmOverwriteBookmark()) {
                return;
            }
            super.buttonAction(n, actionEvent);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                return;
            }
            offsetDialog = null;
            if (this.getValue() != 1) {
                ImageryAdjustAction.this.layer.setOffset(ImageryAdjustAction.this.oldDx, ImageryAdjustAction.this.oldDy);
            } else if (this.tBookmarkName.getText() != null && !"".equals(this.tBookmarkName.getText())) {
                OffsetBookmark.bookmarkOffset(this.tBookmarkName.getText(), ImageryAdjustAction.this.layer);
            }
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            if (Main.map == null) {
                return;
            }
            if (ImageryAdjustAction.this.oldMapMode != null) {
                Main.map.selectMapMode(ImageryAdjustAction.this.oldMapMode);
                ImageryAdjustAction.this.oldMapMode = null;
            } else {
                Main.map.selectSelectTool(false);
            }
        }
    }
}

