/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryInfoAction
extends JosmAction {
    public HistoryInfoAction() {
        super(I18n.tr("History", new Object[0]), "about", I18n.tr("Display history information about OSM ways, nodes, or relations.", new Object[0]), Shortcut.registerShortcut("core:historyinfo", I18n.tr("History", new Object[0]), 72, 5006), false);
        this.putValue("help", HelpUtil.ht("/Action/ObjectHistory"));
        this.putValue("toolbar", "action/historyinfo");
        Main.toolbar.register(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = HistoryInfoAction.getCurrentDataSet();
        if (dataSet != null) {
            HistoryBrowserDialogManager.getInstance().showHistory(dataSet.getAllSelected());
        }
    }

    @Override
    public void updateEnabledState() {
        if (HistoryInfoAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(HistoryInfoAction.getCurrentDataSet().getAllSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(!collection.isEmpty());
    }
}

