/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.NumberWithUnits;
import com.kitfox.svg.xml.ReadableXMLElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Toolkit;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLParseUtil {
    static final Matcher fpMatch = Pattern.compile("([-+]?((\\d*\\.\\d+)|(\\d+))([eE][+-]?\\d+)?)(\\%|in|cm|mm|pt|pc|px|em|ex)?").matcher("");
    static final Matcher intMatch = Pattern.compile("[-+]?\\d+").matcher("");

    private XMLParseUtil() {
    }

    public static String getTagText(Element element) {
        int n;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        Node node = null;
        for (n = 0; n < n2 && !((node = nodeList.item(n)) instanceof Text); ++n) {
        }
        if (n == n2 || node == null) {
            return null;
        }
        return ((Text)node).getData();
    }

    public static Element getFirstChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            return element2;
        }
        return null;
    }

    public static String[] parseStringList(String string) {
        Matcher matcher = Pattern.compile("[^\\s]+").matcher("");
        matcher.reset(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            linkedList.add(matcher.group());
        }
        String[] stringArray = new String[linkedList.size()];
        return linkedList.toArray(stringArray);
    }

    public static boolean isDouble(String string) {
        fpMatch.reset(string);
        return fpMatch.matches();
    }

    public static double parseDouble(String string) {
        return XMLParseUtil.findDouble(string);
    }

    public static synchronized double findDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        fpMatch.reset(string);
        try {
            if (!fpMatch.find()) {
                return 0.0;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("XMLParseUtil: regex parse problem: '" + string + "'");
            stringIndexOutOfBoundsException.printStackTrace();
        }
        string = fpMatch.group(1);
        double d = 0.0;
        try {
            float f;
            d = Double.parseDouble(string);
            try {
                f = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                f = 72.0f;
            }
            String string2 = fpMatch.group(6);
            if ("%".equals(string2)) {
                d /= 100.0;
            } else if ("in".equals(string2)) {
                d *= (double)f;
            } else if ("cm".equals(string2)) {
                d *= (double)(0.3936f * f);
            } else if ("mm".equals(string2)) {
                d *= (double)(0.3936f * f * 0.1f);
            } else if ("pt".equals(string2)) {
                d *= (double)(0.013888889f * f);
            } else if ("pc".equals(string2)) {
                d *= (double)(0.16666667f * f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static synchronized double[] parseDoubleList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        fpMatch.reset(string);
        LinkedList<Double> linkedList = new LinkedList<Double>();
        while (fpMatch.find()) {
            object = fpMatch.group(1);
            linkedList.add(Double.valueOf((String)object));
        }
        object = new double[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = (Double)iterator.next();
        }
        return object;
    }

    public static float parseFloat(String string) {
        return XMLParseUtil.findFloat(string);
    }

    public static synchronized float findFloat(String string) {
        if (string == null) {
            return 0.0f;
        }
        fpMatch.reset(string);
        if (!fpMatch.find()) {
            return 0.0f;
        }
        string = fpMatch.group(1);
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
            String string2 = fpMatch.group(6);
            if ("%".equals(string2)) {
                f /= 100.0f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static synchronized float[] parseFloatList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        fpMatch.reset(string);
        LinkedList<Float> linkedList = new LinkedList<Float>();
        while (fpMatch.find()) {
            object = fpMatch.group(1);
            linkedList.add(Float.valueOf((String)object));
        }
        object = new float[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = ((Float)iterator.next()).floatValue();
        }
        return object;
    }

    public static int parseInt(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int findInt(String string) {
        if (string == null) {
            return 0;
        }
        intMatch.reset(string);
        if (!intMatch.find()) {
            return 0;
        }
        string = intMatch.group();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int[] parseIntList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        intMatch.reset(string);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (intMatch.find()) {
            object = intMatch.group();
            linkedList.add(Integer.valueOf((String)object));
        }
        object = new int[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = (Integer)iterator.next();
        }
        return object;
    }

    public static double parseRatio(String string) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        if (string.charAt(string.length() - 1) == '%') {
            XMLParseUtil.parseDouble(string.substring(0, string.length() - 1));
        }
        return XMLParseUtil.parseDouble(string);
    }

    public static NumberWithUnits parseNumberWithUnits(String string) {
        if (string == null) {
            return null;
        }
        return new NumberWithUnits(string);
    }

    public static String getAttribString(Element element, String string) {
        return element.getAttribute(string);
    }

    public static int getAttribInt(Element element, String string) {
        String string2 = element.getAttribute(string);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int getAttribIntHex(Element element, String string) {
        String string2 = element.getAttribute(string);
        int n = 0;
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static float getAttribFloat(Element element, String string) {
        String string2 = element.getAttribute(string);
        float f = 0.0f;
        try {
            f = Float.parseFloat(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static double getAttribDouble(Element element, String string) {
        String string2 = element.getAttribute(string);
        double d = 0.0;
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static boolean getAttribBoolean(Element element, String string) {
        String string2 = element.getAttribute(string);
        return string2.toLowerCase().equals("true");
    }

    public static URL getAttribURL(Element element, String string, URL uRL) {
        String string2 = element.getAttribute(string);
        try {
            return new URL(uRL, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ReadableXMLElement getElement(Class clazz, Element element, String string, URL uRL) {
        if (element == null) {
            return null;
        }
        if (!ReadableXMLElement.class.isAssignableFrom(clazz)) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            ReadableXMLElement readableXMLElement = null;
            try {
                readableXMLElement = (ReadableXMLElement)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            readableXMLElement.read(element2, uRL);
            if (readableXMLElement == null) continue;
            return readableXMLElement;
        }
        return null;
    }

    public static HashMap getElementHashMap(Class clazz, Element element, String string, String string2, URL uRL) {
        if (element == null) {
            return null;
        }
        if (!ReadableXMLElement.class.isAssignableFrom(clazz)) {
            return null;
        }
        HashMap<String, ReadableXMLElement> hashMap = new HashMap<String, ReadableXMLElement>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            ReadableXMLElement readableXMLElement = null;
            try {
                readableXMLElement = (ReadableXMLElement)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            readableXMLElement.read(element2, uRL);
            if (readableXMLElement == null) continue;
            String string3 = XMLParseUtil.getAttribString(element2, string2);
            hashMap.put(string3, readableXMLElement);
        }
        return hashMap;
    }

    public static HashSet getElementHashSet(Class clazz, Element element, String string, URL uRL) {
        if (element == null) {
            return null;
        }
        if (!ReadableXMLElement.class.isAssignableFrom(clazz)) {
            return null;
        }
        HashSet<ReadableXMLElement> hashSet = new HashSet<ReadableXMLElement>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            ReadableXMLElement readableXMLElement = null;
            try {
                readableXMLElement = (ReadableXMLElement)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            readableXMLElement.read(element2, uRL);
            if (readableXMLElement == null) continue;
            hashSet.add(readableXMLElement);
        }
        return hashSet;
    }

    public static LinkedList getElementLinkedList(Class clazz, Element element, String string, URL uRL) {
        if (element == null) {
            return null;
        }
        if (!ReadableXMLElement.class.isAssignableFrom(clazz)) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        LinkedList<ReadableXMLElement> linkedList = new LinkedList<ReadableXMLElement>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getTagName().equals(string)) continue;
            ReadableXMLElement readableXMLElement = null;
            try {
                readableXMLElement = (ReadableXMLElement)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            readableXMLElement.read(element2, uRL);
            linkedList.addLast(readableXMLElement);
        }
        return linkedList;
    }

    public static Object[] getElementArray(Class clazz, Element element, String string, URL uRL) {
        if (element == null) {
            return null;
        }
        if (!ReadableXMLElement.class.isAssignableFrom(clazz)) {
            return null;
        }
        LinkedList linkedList = XMLParseUtil.getElementLinkedList(clazz, element, string, uRL);
        Object[] objectArray = (Object[])Array.newInstance(clazz, linkedList.size());
        return linkedList.toArray(objectArray);
    }

    public static int[] getElementArrayInt(Element element, String string, String string2) {
        Object object;
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            object = nodeList.item(i);
            if (!(object instanceof Element) || !(element2 = (Element)object).getTagName().equals(string)) continue;
            String string3 = element2.getAttribute(string2);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            linkedList.addLast(new Integer(n2));
        }
        int[] nArray = new int[linkedList.size()];
        object = linkedList.iterator();
        int n3 = 0;
        while (object.hasNext()) {
            nArray[n3++] = (Integer)object.next();
        }
        return nArray;
    }

    public static String[] getElementArrayString(Element element, String string, String string2) {
        Object object;
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            object = nodeList.item(i);
            if (!(object instanceof Element) || !(element2 = (Element)object).getTagName().equals(string)) continue;
            String string3 = element2.getAttribute(string2);
            linkedList.addLast(string3);
        }
        String[] stringArray = new String[linkedList.size()];
        object = linkedList.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            stringArray[n2++] = (String)object.next();
        }
        return stringArray;
    }

    public static HashMap parseStyle(String string) {
        return XMLParseUtil.parseStyle(string, new HashMap());
    }

    public static HashMap parseStyle(String string, HashMap hashMap) {
        Pattern pattern = Pattern.compile(";");
        Pattern pattern2 = Pattern.compile(":");
        Matcher matcher = Pattern.compile("\\s*([^\\s](.*[^\\s])?)\\s*").matcher("");
        String[] stringArray = pattern.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            String[] stringArray2 = pattern2.split(stringArray[i]);
            matcher.reset(stringArray2[0]);
            matcher.matches();
            stringArray2[0] = matcher.group(1);
            matcher.reset(stringArray2[1]);
            matcher.matches();
            stringArray2[1] = matcher.group(1);
            hashMap.put(stringArray2[0], new StyleAttribute(stringArray2[0], stringArray2[1]));
        }
        return hashMap;
    }
}

