/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageSessionExporter
implements SessionLayerExporter {
    private GeoImageLayer layer;
    private JCheckBox export;

    public GeoImageSessionExporter(GeoImageLayer geoImageLayer) {
        this.layer = geoImageLayer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        if (this.layer.getGpxLayer() != null) {
            return Collections.singleton(this.layer.getGpxLayer());
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return false;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "geoimage");
        element.setAttribute("version", "0.1");
        for (ImageEntry imageEntry : this.layer.getImages()) {
            Element element2;
            Element element3 = exportSupport.createElement("geoimage");
            if (imageEntry.getFile() == null) {
                Main.warn("No file attribute for image - skipping entry");
                break;
            }
            this.addAttr("file", imageEntry.getFile().getPath(), element3, exportSupport);
            this.addAttr("thumbnail", Boolean.toString(imageEntry.hasThumbnail()), element3, exportSupport);
            if (imageEntry.getPos() != null) {
                element2 = exportSupport.createElement("position");
                element2.setAttribute("lat", Double.toString(imageEntry.getPos().lat()));
                element2.setAttribute("lon", Double.toString(imageEntry.getPos().lon()));
                element3.appendChild(element2);
            }
            if (imageEntry.getSpeed() != null) {
                this.addAttr("speed", imageEntry.getSpeed().toString(), element3, exportSupport);
            }
            if (imageEntry.getElevation() != null) {
                this.addAttr("elevation", imageEntry.getElevation().toString(), element3, exportSupport);
            }
            if (imageEntry.getGpsTime() != null) {
                this.addAttr("gps-time", Long.toString(imageEntry.getGpsTime().getTime()), element3, exportSupport);
            }
            if (imageEntry.getExifOrientation() != null) {
                this.addAttr("exif-orientation", Integer.toString(imageEntry.getExifOrientation()), element3, exportSupport);
            }
            if (imageEntry.getExifTime() != null) {
                this.addAttr("exif-time", Long.toString(imageEntry.getExifTime().getTime()), element3, exportSupport);
            }
            if (imageEntry.getExifCoor() != null) {
                element2 = exportSupport.createElement("exif-coordinates");
                element2.setAttribute("lat", Double.toString(imageEntry.getExifCoor().lat()));
                element2.setAttribute("lon", Double.toString(imageEntry.getExifCoor().lon()));
                element3.appendChild(element2);
            }
            if (imageEntry.getExifImgDir() != null) {
                this.addAttr("exif-image-direction", imageEntry.getExifImgDir().toString(), element3, exportSupport);
            }
            element.appendChild(element3);
        }
        return element;
    }

    private void addAttr(String string, String string2, Element element, SessionWriter.ExportSupport exportSupport) {
        Element element2 = exportSupport.createElement(string);
        element2.appendChild(exportSupport.createTextNode(string2));
        element.appendChild(element2);
    }
}

