/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class OsmServerReader
extends OsmConnection {
    private OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate = false;
    protected boolean gpxParsedProperly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            string = string.startsWith("http") ? string : this.getBaseUrl() + string;
            InputStream inputStream = this.getInputStreamRaw(string, progressMonitor);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected String getBaseUrl() {
        return this.api.getBaseUrl();
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            URL uRL = null;
            try {
                uRL = new URL(string.replace(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new OsmTransferException(malformedURLException);
            }
            try {
                this.activeConnection = Utils.openHttpConnection(uRL, false);
            }
            catch (Exception exception) {
                throw new OsmTransferException(I18n.tr("Failed to open connection to API {0}.", uRL.toExternalForm()), exception);
            }
            if (this.cancel) {
                this.activeConnection.disconnect();
                InputStream inputStream = null;
                return inputStream;
            }
            if (this.doAuthenticate) {
                this.addAuth(this.activeConnection);
            }
            if (this.cancel) {
                throw new OsmTransferCanceledException();
            }
            if (Main.pref.getBoolean("osm-server.use-compression", true)) {
                this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            this.activeConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
            try {
                System.out.println("GET " + uRL);
                this.activeConnection.connect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                OsmTransferException osmTransferException = new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection.", new Object[0]), exception);
                osmTransferException.setUrl(uRL.toString());
                throw osmTransferException;
            }
            try {
                if (this.activeConnection.getResponseCode() == 401) {
                    throw new OsmApiException(401, null, null);
                }
                if (this.activeConnection.getResponseCode() == 407) {
                    throw new OsmTransferCanceledException();
                }
                String string2 = this.activeConnection.getContentEncoding();
                if (this.activeConnection.getResponseCode() != 200) {
                    String string3 = this.activeConnection.getHeaderField("Error");
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        InputStream inputStream = this.FixEncoding(this.activeConnection.getErrorStream(), string2);
                        if (inputStream != null) {
                            String string4;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            while ((string4 = bufferedReader.readLine()) != null) {
                                stringBuilder.append(string4);
                                stringBuilder.append("\n");
                            }
                        }
                    }
                    catch (Exception exception) {
                        stringBuilder.append(I18n.tr("Reading error text failed.", new Object[0]));
                    }
                    throw new OsmApiException(this.activeConnection.getResponseCode(), string3, stringBuilder.toString(), uRL.toString());
                }
                InputStream inputStream = this.FixEncoding(new ProgressInputStream(this.activeConnection, progressMonitor), string2);
                return inputStream;
            }
            catch (Exception exception) {
                if (exception instanceof OsmTransferException) {
                    throw (OsmTransferException)exception;
                }
                throw new OsmTransferException(exception);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    private InputStream FixEncoding(InputStream inputStream, String string) throws IOException {
        if (string != null && string.equalsIgnoreCase("gzip")) {
            inputStream = new GZIPInputStream(inputStream);
        } else if (string != null && string.equalsIgnoreCase("deflate")) {
            inputStream = new InflaterInputStream(inputStream, new Inflater(true));
        }
        return inputStream;
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean bl) {
        this.doAuthenticate = bl;
    }

    public final boolean isGpxParsedProperly() {
        return this.gpxParsedProperly;
    }
}

