/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(OsmImporter.FILE_FILTER);
    }

    public OsmExporter(ExtensionFileFilter extensionFileFilter) {
        super(extensionFileFilter);
    }

    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    public void exportData(File file, Layer layer) throws IOException {
        this.exportData(file, layer, false);
    }

    public void exportData(File file, Layer layer, boolean bl) throws IOException {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        this.save(file, (OsmDataLayer)layer, bl);
    }

    protected OutputStream getOutputStream(File file) throws FileNotFoundException, IOException {
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file, OsmDataLayer osmDataLayer, boolean bl) {
        File file2 = null;
        try {
            if (file.exists()) {
                file2 = new File(file.getPath() + "~");
                Utils.copyFile(file, file2);
            }
            OutputStream outputStream = this.getOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(outputStreamWriter), false, osmDataLayer.data.getVersion());
            osmDataLayer.data.getReadLock().lock();
            try {
                osmWriter.writeLayer(osmDataLayer);
            }
            finally {
                Utils.close(osmWriter);
                osmDataLayer.data.getReadLock().unlock();
            }
            if ((bl || !Main.pref.getBoolean("save.keepbackup", false)) && file2 != null) {
                file2.delete();
            }
            osmDataLayer.onPostSaveToFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
            try {
                if (file2 != null && file2.exists()) {
                    Utils.copyFile(file2, file);
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", iOException2.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }
}

