/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;

public class OsmChangeReader
extends OsmReader {
    public static final String[] ACTIONS = new String[]{"create", "modify", "delete"};

    protected OsmChangeReader() {
    }

    protected void parseRoot() throws XMLStreamException {
        if (this.parser.getLocalName().equals("osmChange")) {
            this.parseOsmChange();
        } else {
            this.parseUnknown();
        }
    }

    private void parseOsmChange() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "version");
        if (string == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!string.equals("0.6")) {
            this.throwException(I18n.tr("Unsupported version: {0}", string));
        }
        this.ds.setVersion(string);
        while (this.parser.hasNext()) {
            int n = this.parser.next();
            if (n == 1) {
                if (Arrays.asList(ACTIONS).contains(this.parser.getLocalName())) {
                    this.parseCommon(this.parser.getLocalName());
                    continue;
                }
                this.parseUnknown();
                continue;
            }
            if (n != 2) continue;
            return;
        }
    }

    private void parseCommon(String string) throws XMLStreamException {
        while (this.parser.hasNext()) {
            int n = this.parser.next();
            if (n == 1) {
                OsmPrimitive osmPrimitive = null;
                if (this.parser.getLocalName().equals("node")) {
                    osmPrimitive = this.parseNode();
                } else if (this.parser.getLocalName().equals("way")) {
                    osmPrimitive = this.parseWay();
                } else if (this.parser.getLocalName().equals("relation")) {
                    osmPrimitive = this.parseRelation();
                } else {
                    this.parseUnknown();
                }
                if (osmPrimitive == null || string == null) continue;
                if (string.equals("modify")) {
                    osmPrimitive.setModified(true);
                    continue;
                }
                if (!string.equals("delete")) continue;
                osmPrimitive.setDeleted(true);
                continue;
            }
            if (n != 2) continue;
            return;
        }
    }

    public static DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        return new OsmChangeReader().doParseDataSet(inputStream, progressMonitor);
    }
}

