/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class GeoJSONWriter
implements Visitor {
    private OsmDataLayer layer;
    private StringBuilder out;
    private final boolean skipEmptyNodes = true;
    private boolean insertComma = false;

    public GeoJSONWriter(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public String write() {
        this.out = new StringBuilder(4096);
        this.out.append("{\"type\": \"FeatureCollection\",\n");
        this.out.append("\"features\": [\n");
        for (Node osmPrimitive : this.layer.data.getNodes()) {
            this.appendPrimitive(osmPrimitive);
        }
        for (Way way : this.layer.data.getWays()) {
            this.appendPrimitive(way);
        }
        this.out.append("\n]\n}");
        return this.out.toString();
    }

    public void visit(Node node) {
        this.out.append("\"type\": \"Point\", \"coordinates\": ");
        this.appendCoord(node.getCoor());
    }

    public void visit(Way way) {
        this.out.append("\"type\": \"LineString\", \"coordinates\": [");
        boolean bl = false;
        for (Node node : way.getNodes()) {
            if (bl) {
                this.out.append(", ");
            }
            bl = true;
            this.appendCoord(node.getCoor());
        }
        this.out.append("]");
    }

    public void visit(Relation relation) {
    }

    public void visit(Changeset changeset) {
    }

    protected String escape(String string) {
        return string.replace("\"", "\\\"").replace("\\", "\\\\").replace("\n", "\\n");
    }

    protected void appendPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive.isIncomplete()) {
            return;
        }
        if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) {
            return;
        }
        if (this.insertComma) {
            this.out.append(",\n");
        }
        this.insertComma = true;
        this.out.append("{\"type\": \"Feature\",\n");
        Map<String, String> map = osmPrimitive.getKeys();
        if (!map.isEmpty()) {
            this.out.append("\t\"properties\": {\n");
            boolean bl = false;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (bl) {
                    this.out.append(",\n");
                }
                bl = true;
                this.out.append("\t\t\"").append(this.escape(entry.getKey())).append("\": ");
                this.out.append("\"").append(this.escape(entry.getValue())).append("\"");
            }
            this.out.append("\n\t},\n");
        } else {
            this.out.append("\t\"properties\": {},\n");
        }
        this.out.append("\t\"geometry\": {");
        osmPrimitive.visit(this);
        this.out.append("}");
        this.out.append("}");
    }

    protected void appendCoord(LatLon latLon) {
        if (latLon != null) {
            this.out.append("[").append(latLon.lon()).append(", ").append(latLon.lat()).append("]");
        }
    }
}

