/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.QuadStateCheckBox;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPreset
extends AbstractAction
implements MapView.LayerChangeListener {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public TaggingPresetMenu group = null;
    public String name;
    public String name_context;
    public String locale_name;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    private static File zipIcons = null;
    private static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    public static final String DIFFERENT = I18n.tr("<different>", new Object[0]);
    public EnumSet<PresetType> types;
    public List<Item> data = new LinkedList<Item>();
    public Roles roles;
    public TemplateEntry nameTemplate;
    public SearchCompiler.Match nameTemplateFilter;
    private static final HashMap<String, String> lastValue = new HashMap();
    private static int auto_increment_selected = 0;
    private static final Map<String, EnumSet<PresetType>> typeCache = new LinkedHashMap<String, EnumSet<PresetType>>(16, 1.1f, true);
    private boolean originalSelectionEmpty = false;

    static Usage determineTextUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                usage.values.add(string2);
            } else {
                usage.hadEmpty = true;
            }
            if (!osmPrimitive.hasKeys()) continue;
            usage.hadKeys = true;
        }
        return usage;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = OsmUtils.getNamedOsmBoolean(osmPrimitive.get(string));
            if (string2 == null) continue;
            usage.values.add(string2);
        }
        return usage;
    }

    private static String[] splitEscaped(char c, String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                stringBuilder.append(c2);
                bl = false;
                continue;
            }
            if (c2 == '\\') {
                bl = true;
                continue;
            }
            if (c2 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public TaggingPreset() {
        MapView.addLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue(OPTIONAL_TOOLTIP_TEXT, this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, TaggingPreset.fixPresetString(this.name)) : I18n.tr(TaggingPreset.fixPresetString(this.name), new Object[0]);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    protected static ImageIcon loadImageIcon(String string, File file, Integer n) {
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageProvider imageProvider = new ImageProvider(string).setDirs(collection).setId("presets").setArchive(file).setOptional(true);
        if (n != null) {
            imageProvider.setMaxSize(n);
        }
        return imageProvider.get();
    }

    public void setIcon(final String string) {
        ImageProvider imageProvider = new ImageProvider(string);
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        imageProvider.setDirs(collection);
        imageProvider.setId("presets");
        imageProvider.setArchive(zipIcons);
        imageProvider.setOptional(true);
        imageProvider.setMaxWidth(16).setMaxHeight(16);
        imageProvider.getInBackground(new ImageProvider.ImageCallback(){

            public void finished(final ImageIcon imageIcon) {
                if (imageIcon != null) {
                    GuiHelper.runInEDT(new Runnable(){

                        public void run() {
                            TaggingPreset.this.putValue("SmallIcon", imageIcon);
                        }
                    });
                } else {
                    System.out.println("Could not get presets icon " + string);
                }
            }
        });
    }

    public static EnumSet<PresetType> getType(String string) throws SAXException {
        if (typeCache.containsKey(string)) {
            return typeCache.get(string);
        }
        EnumSet<PresetType> enumSet = EnumSet.noneOf(PresetType.class);
        for (String string2 : Arrays.asList(string.split(","))) {
            try {
                PresetType presetType = PresetType.fromString(string2);
                enumSet.add(presetType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(I18n.tr("Unknown type: {0}", string2));
            }
        }
        typeCache.put(string, enumSet);
        return enumSet;
    }

    public void setType(String string) throws SAXException {
        this.types = TaggingPreset.getType(string);
    }

    public void setName_template(String string) throws SAXException {
        try {
            this.nameTemplate = new TemplateParser(string).parse();
        }
        catch (ParseError parseError) {
            System.err.println("Error while parsing " + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    public void setName_template_filter(String string) throws SAXException {
        try {
            this.nameTemplateFilter = SearchCompiler.compile(string, false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            System.err.println("Error while parsing" + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    public static List<TaggingPreset> readAll(Reader reader, boolean bl) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", Text.class);
        xmlObjectParser.map("link", Link.class);
        xmlObjectParser.mapOnStart("optional", Optional.class);
        xmlObjectParser.mapOnStart("roles", Roles.class);
        xmlObjectParser.map("role", Role.class);
        xmlObjectParser.map("check", Check.class);
        xmlObjectParser.map("combo", Combo.class);
        xmlObjectParser.map("multiselect", MultiSelect.class);
        xmlObjectParser.map("label", Label.class);
        xmlObjectParser.map("space", Space.class);
        xmlObjectParser.map("key", Key.class);
        xmlObjectParser.map("list_entry", PresetListEntry.class);
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        TaggingPreset taggingPreset = null;
        Roles roles = null;
        LinkedList<PresetListEntry> linkedList2 = new LinkedList<PresetListEntry>();
        if (bl) {
            xmlObjectParser.startWithValidation(reader, "http://josm.openstreetmap.de/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            xmlObjectParser.start(reader);
        }
        while (xmlObjectParser.hasNext()) {
            TaggingPreset taggingPreset2;
            Object object = xmlObjectParser.next();
            if (object instanceof TaggingPresetMenu) {
                taggingPreset2 = (TaggingPresetMenu)object;
                if (taggingPreset2 == taggingPreset) {
                    taggingPreset = ((TaggingPresetMenu)taggingPreset2).group;
                } else {
                    ((TaggingPresetMenu)taggingPreset2).group = taggingPreset;
                    ((TaggingPresetMenu)taggingPreset2).setDisplayName();
                    taggingPreset = taggingPreset2;
                    linkedList.add(taggingPreset2);
                }
                roles = null;
                continue;
            }
            if (object instanceof TaggingPresetSeparator) {
                taggingPreset2 = (TaggingPresetSeparator)object;
                ((TaggingPresetSeparator)taggingPreset2).group = taggingPreset;
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (object instanceof TaggingPreset) {
                taggingPreset2 = (TaggingPreset)object;
                taggingPreset2.group = taggingPreset;
                taggingPreset2.setDisplayName();
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (linkedList.size() != 0) {
                if (object instanceof Roles) {
                    linkedList.getLast().data.add((Item)object);
                    if (linkedList.getLast().roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    linkedList.getLast().roles = (Roles)object;
                    roles = (Roles)object;
                    continue;
                }
                if (object instanceof Role) {
                    if (roles == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    roles.roles.add((Role)object);
                    continue;
                }
                if (object instanceof PresetListEntry) {
                    linkedList2.add((PresetListEntry)object);
                    continue;
                }
                linkedList.getLast().data.add((Item)object);
                if (object instanceof ComboMultiSelect) {
                    ((ComboMultiSelect)object).addListEntries(linkedList2);
                } else if (object instanceof Key && ((Key)object).value == null) {
                    ((Key)object).value = "";
                }
                linkedList2 = new LinkedList();
                roles = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TaggingPreset> readAll(String string, boolean bl) throws SAXException, IOException {
        List<TaggingPreset> list;
        MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
        try {
            InputStreamReader inputStreamReader;
            InputStream inputStream = mirroredInputStream.getZipEntry("xml", "preset");
            if (inputStream != null) {
                zipIcons = mirroredInputStream.getFile();
            }
            try {
                inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream);
            }
            try {
                list = TaggingPreset.readAll(new BufferedReader(inputStreamReader), bl);
            }
            finally {
                Utils.close(inputStreamReader);
            }
        }
        finally {
            Utils.close(mirroredInputStream);
        }
        return list;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl) {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        for (String string : collection) {
            try {
                linkedList.addAll(TaggingPreset.readAll(string, bl));
            }
            catch (IOException iOException) {
                System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                System.err.println(string);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string), I18n.tr("Error", new Object[0]), 0);
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getClass().getName() + ": " + sAXException.getMessage());
                System.err.println(string);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error parsing {0}: ", string) + sAXException.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }
        return linkedList;
    }

    public static LinkedList<String> getPresetSources() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (SourceEntry sourceEntry : new TaggingPresetPreference.PresetPrefHelper().get()) {
            linkedList.add(sourceEntry.url);
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean bl) {
        return TaggingPreset.readAll(TaggingPreset.getPresetSources(), bl);
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> collection) {
        JPanel jPanel;
        if (this.data == null) {
            return null;
        }
        PresetPanel presetPanel = new PresetPanel();
        LinkedList<Item> linkedList = new LinkedList<Item>();
        if (this.types != null) {
            jPanel = new JPanel();
            for (PresetType object : this.types) {
                JLabel jLabel = new JLabel(ImageProvider.get(object.getIconName()));
                jLabel.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(object.getName(), new Object[0])));
                jPanel.add(jLabel);
            }
            presetPanel.add((Component)jPanel, GBC.eol());
        }
        jPanel = new JPanel(new GridBagLayout());
        for (Item item : this.data) {
            if (item instanceof Link) {
                linkedList.add(item);
                continue;
            }
            if (!item.addToPanel(jPanel, collection)) continue;
            presetPanel.hasElements = true;
        }
        presetPanel.add((Component)jPanel, GBC.eol().fill());
        if (collection.size() == 0 && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(jPanel, false);
        }
        for (Item item : linkedList) {
            item.addToPanel(presetPanel, collection);
        }
        return presetPanel;
    }

    public boolean isShowable() {
        for (Item item : this.data) {
            if (item instanceof Optional || item instanceof Space || item instanceof Key) continue;
            return true;
        }
        return false;
    }

    public String suggestRoleForOsmPrimitive(OsmPrimitive osmPrimitive) {
        if (this.roles != null && osmPrimitive != null) {
            for (Role role : this.roles.roles) {
                if (role.memberExpression == null || !role.memberExpression.match(osmPrimitive) || role.types != null && !role.types.isEmpty() && !role.types.contains((Object)PresetType.forPrimitive(osmPrimitive))) continue;
                return role.key;
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main == null) {
            return;
        }
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.createSelection(Main.main.getCurrentDataSet().getSelected());
        int n = this.showDialog(collection, this.supportsRelation());
        if (collection.size() != 0 && n == 1) {
            Command command = TaggingPreset.createCommand(collection, this.getChangedTags());
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        } else if (n == 2) {
            final Relation relation = new Relation();
            final HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            for (Tag object : this.getChangedTags()) {
                relation.put(object.getKey(), object.getValue());
            }
            for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                String string = this.suggestRoleForOsmPrimitive(osmPrimitive);
                RelationMember relationMember = new RelationMember(string == null ? "" : string, osmPrimitive);
                relation.addMember(relationMember);
                hashSet.add(relationMember);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RelationEditor.getEditor(Main.main.getEditLayer(), relation, hashSet).setVisible(true);
                }
            });
        }
        Main.main.getCurrentDataSet().setSelected(Main.main.getCurrentDataSet().getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> collection, final boolean bl) {
        PresetPanel presetPanel = this.createPanel(collection);
        if (presetPanel == null) {
            return 3;
        }
        int n = 1;
        if (presetPanel.getComponentCount() != 0 && (collection.size() == 0 || presetPanel.hasElements)) {
            String string = I18n.trn("Change {0} object", "Change {0} objects", collection.size(), collection.size());
            if (collection.size() == 0) {
                string = this.originalSelectionEmpty ? I18n.tr("Nothing selected!", new Object[0]) : I18n.tr("Selection unsuitable!", new Object[0]);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component component, String string, ImageIcon imageIcon, boolean bl3) {
                    String[] stringArray;
                    if (bl2) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = I18n.tr("Apply Preset", new Object[0]);
                        stringArray2[1] = I18n.tr("New relation", new Object[0]);
                        stringArray = stringArray2;
                        stringArray2[2] = I18n.tr("Cancel", new Object[0]);
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = I18n.tr("Apply Preset", new Object[0]);
                        stringArray = stringArray3;
                        stringArray3[1] = I18n.tr("Cancel", new Object[0]);
                    }
                    super(Main.parent, string, stringArray, true);
                    if (imageIcon != null) {
                        this.setIconImage(imageIcon.getImage());
                    }
                    this.contentInsets = new Insets(10, 5, 0, 5);
                    if (bl) {
                        this.setButtonIcons(new String[]{"ok.png", "dialogs/addrelation.png", "cancel.png"});
                    } else {
                        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                    }
                    this.setContent(component);
                    this.setDefaultButton(1);
                    this.setupDialog();
                    ((JButton)this.buttons.get(0)).setEnabled(!bl3);
                    ((JButton)this.buttons.get(0)).setToolTipText(string);
                    Dimension dimension = this.getSize();
                    if (dimension.width < 350) {
                        dimension.width = 350;
                        this.setSize(dimension);
                    }
                    this.showDialog();
                }
            }
            n = new PresetDialog(presetPanel, string, (ImageIcon)this.getValue("SmallIcon"), collection.size() == 0).getValue();
        }
        if (!bl && n == 2) {
            return 3;
        }
        return n;
    }

    public Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> collection) {
        this.originalSelectionEmpty = collection.size() == 0;
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (this.types != null && (osmPrimitive instanceof Relation ? !this.types.contains((Object)PresetType.RELATION) && (!this.types.contains((Object)PresetType.CLOSEDWAY) || !((Relation)osmPrimitive).isMultipolygon()) : (osmPrimitive instanceof Node ? !this.types.contains((Object)PresetType.NODE) : osmPrimitive instanceof Way && !this.types.contains((Object)PresetType.WAY) && (!this.types.contains((Object)PresetType.CLOSEDWAY) || !((Way)osmPrimitive).isClosed())))) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Item item : this.data) {
            item.addCommands(arrayList);
        }
        return arrayList;
    }

    private static String fixPresetString(String string) {
        return string == null ? string : string.replaceAll("'", "''");
    }

    public static Command createCommand(Collection<OsmPrimitive> collection, List<Tag> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : list) {
            arrayList.add(new ChangePropertyCommand(collection, tag.getKey(), tag.getValue()));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Properties", new Object[0]), arrayList);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)PresetType.RELATION);
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types) + " " + this.name;
    }

    public boolean typeMatches(Collection<PresetType> collection) {
        return collection == null || this.types == null || this.types.containsAll(collection);
    }

    public boolean matches(Collection<PresetType> collection, Map<String, String> map, boolean bl) {
        if (bl && !this.isShowable()) {
            return false;
        }
        if (!this.typeMatches(collection)) {
            return false;
        }
        boolean bl2 = false;
        for (Item item : this.data) {
            Boolean bl3 = item.matches(map);
            if (bl3 != null && !bl3.booleanValue()) {
                return false;
            }
            if (bl3 == null) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static Collection<TaggingPreset> getMatchingPresets(final Collection<PresetType> collection, final Map<String, String> map, final boolean bl) {
        return Utils.filter(TaggingPresetPreference.taggingPresets, new Predicate<TaggingPreset>(){

            @Override
            public boolean evaluate(TaggingPreset taggingPreset) {
                return taggingPreset.matches(collection, map, bl);
            }
        });
    }

    static /* synthetic */ File access$000() {
        return zipIcons;
    }

    private static class PresetPanel
    extends JPanel {
        boolean hasElements = false;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends KeyedItem {
        public String value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
            list.add(new Tag(this.key, this.value));
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.KEY_VALUE;
        }

        @Override
        public Collection<String> getValues() {
            return Collections.singleton(this.value);
        }

        @Override
        public String toString() {
            return "Key [key=" + this.key + ", value=" + this.value + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Space
    extends Item {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Optional
    extends Item {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Optional Attributes:", new Object[0])), GBC.eol());
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Roles
    extends Item {
        public final List<Role> roles = new LinkedList<Role>();

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            if (this.roles.size() > 0) {
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel2.add((Component)new JLabel(I18n.tr("Available roles", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("role", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("count", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("elements", new Object[0])), GBC.eol());
                for (Role role : this.roles) {
                    role.addToPanel(jPanel2, collection);
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Role {
        public EnumSet<PresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public SearchCompiler.Match memberExpression;
        public boolean required = false;
        public long count = 0L;

        public void setType(String string) throws SAXException {
            this.types = TaggingPreset.getType(string);
        }

        public void setRequisite(String string) throws SAXException {
            if ("required".equals(string)) {
                this.required = true;
            } else if (!"optional".equals(string)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", string));
            }
        }

        public void setMember_expression(String string) throws SAXException {
            try {
                this.memberExpression = SearchCompiler.compile(string, true, true);
            }
            catch (SearchCompiler.ParseError parseError) {
                throw new SAXException(I18n.tr("Illegal member expression: {0}", parseError.getMessage()), parseError);
            }
        }

        public long getValidCount(long l) {
            if (this.count > 0L && !this.required) {
                return l != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return l != 0L ? l : 0L;
            }
            return l != 0L ? l : 1L;
        }

        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string = this.count > 0L && !this.required ? "0," + String.valueOf(this.count) : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text)) : I18n.tr(TaggingPreset.fixPresetString(this.text), new Object[0]);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(string), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel jPanel2 = new JPanel();
                for (PresetType presetType : this.types) {
                    jPanel2.add(new JLabel(ImageProvider.get(presetType.getIconName())));
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Item {
        public String href;
        public String text;
        public String text_context;
        public String locale_text;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string;
            if (this.locale_text == null) {
                this.locale_text = this.text == null ? I18n.tr("More information about this feature", new Object[0]) : (this.text_context != null ? I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text)) : I18n.tr(TaggingPreset.fixPresetString(this.text), new Object[0]));
            }
            if ((string = this.locale_href) == null) {
                string = this.href;
            }
            if (string != null) {
                jPanel.add((Component)new UrlLabel(string, this.locale_text, 2), GBC.eol().anchor(17));
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Label
    extends Item {
        public String text;
        public String text_context;
        public String locale_text;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text)) : I18n.tr(TaggingPreset.fixPresetString(this.text), new Object[0]);
            }
            jPanel.add((Component)new JLabel(this.locale_text), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiSelect
    extends ComboMultiSelect {
        public long rows = -1L;
        protected ConcatenatingJList list;

        @Override
        protected void addToPanelAnchor(JPanel jPanel, String string) {
            this.list = new ConcatenatingJList(this.delimiter, this.lhm.values().toArray());
            this.component = this.list;
            ListCellRenderer listCellRenderer = this.getListCellRenderer();
            this.list.setCellRenderer(listCellRenderer);
            if (this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.originalValue = this.usage.getFirst();
                this.list.setSelectedItem(this.originalValue);
            } else if (string != null && !this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(string);
            } else if (this.usage.unused()) {
                this.originalValue = null;
                this.list.setSelectedItem(this.originalValue);
            } else {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(this.originalValue);
            }
            JScrollPane jScrollPane = new JScrollPane(this.list);
            if (this.rows != -1L) {
                double d = listCellRenderer.getListCellRendererComponent(this.list, new PresetListEntry("x"), 0, false, false).getPreferredSize().getHeight() * (double)this.rows;
                jScrollPane.setPreferredSize(new Dimension((int)jScrollPane.getPreferredSize().getWidth(), (int)d));
            }
            jPanel.add((Component)jScrollPane, GBC.eol().fill(2));
        }

        @Override
        protected Object getSelectedItem() {
            return this.list.getSelectedItem();
        }

        @Override
        public void addCommands(List<Tag> list) {
            if (this.list.isEnabled()) {
                super.addCommands(list);
            }
        }
    }

    public static class ConcatenatingJList
    extends JList {
        private String delimiter;

        public ConcatenatingJList(String string, Object[] objectArray) {
            super(objectArray);
            this.delimiter = string;
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                this.clearSelection();
            } else {
                String string = object.toString();
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(string.split(this.delimiter)));
                ListModel listModel = this.getModel();
                int[] nArray = new int[listModel.getSize()];
                int n = 0;
                for (int i = 0; i < listModel.getSize(); ++i) {
                    if (!treeSet.contains(((PresetListEntry)listModel.getElementAt((int)i)).value)) continue;
                    nArray[n++] = i;
                }
                this.setSelectedIndices(Arrays.copyOf(nArray, n));
                this.setEnabled(Utils.join(this.delimiter, treeSet).equals(this.getSelectedItem()));
            }
        }

        public String getSelectedItem() {
            ListModel listModel = this.getModel();
            int[] nArray = this.getSelectedIndices();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.delimiter);
                }
                stringBuilder.append(((PresetListEntry)listModel.getElementAt((int)nArray[i])).value);
            }
            return stringBuilder.toString();
        }
    }

    public static class Combo
    extends ComboMultiSelect {
        public boolean editable = true;
        protected JosmComboBox combo;

        public Combo() {
            this.delimiter = ",";
        }

        protected void addToPanelAnchor(JPanel jPanel, String string) {
            if (!this.usage.unused()) {
                for (String object2 : this.usage.values) {
                    if (this.lhm.containsKey(object2)) continue;
                    this.lhm.put(object2, new PresetListEntry(object2));
                }
            }
            if (string != null && !this.lhm.containsKey(string)) {
                this.lhm.put(string, new PresetListEntry(string));
            }
            this.lhm.put("", new PresetListEntry(""));
            this.combo = new JosmComboBox(this.lhm.values().toArray());
            this.component = this.combo;
            this.combo.setRenderer(this.getListCellRenderer());
            this.combo.setEditable(this.editable);
            this.combo.reinitialize(this.lhm.values());
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            AutoCompletionList autoCompletionList = autoCompletingTextField.getAutoCompletionList();
            if (autoCompletionList != null) {
                autoCompletionList.add(this.getDisplayValues(), AutoCompletionItemPritority.IS_IN_STANDARD);
            }
            this.combo.setEditor(autoCompletingTextField);
            if (this.usage.hasUniqueValue()) {
                this.originalValue = this.lhm.get(this.usage.getFirst());
                this.combo.setSelectedItem(this.originalValue);
            } else if (string != null && this.usage.unused()) {
                if (!this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    this.combo.setSelectedItem(((PresetListEntry)this.lhm.get(string)).getDisplayValue(true));
                } else {
                    this.combo.setSelectedItem("");
                }
                this.originalValue = this.lhm.get(DIFFERENT);
            } else if (this.usage.unused()) {
                this.originalValue = this.lhm.get("");
                if ("force".equals(this.use_last_as_default) && lastValue.containsKey(this.key)) {
                    this.combo.setSelectedItem(this.lhm.get(lastValue.get(this.key)));
                } else {
                    this.combo.setSelectedItem(this.originalValue);
                }
            } else {
                this.originalValue = this.lhm.get(DIFFERENT);
                this.combo.setSelectedItem(this.originalValue);
            }
            jPanel.add((Component)this.combo, GBC.eol().fill(2));
        }

        protected Object getSelectedItem() {
            return this.combo.getSelectedItem();
        }

        protected String getDisplayIfNull(String string) {
            if (this.combo.isEditable()) {
                return this.combo.getEditor().getItem().toString();
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComboMultiSelect
    extends KeyedItem {
        public String locale_text;
        public String values;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String short_descriptions;
        public String locale_short_descriptions;
        public String default_;
        public String delimiter = ";";
        public String use_last_as_default = "false";
        protected JComponent component;
        protected final Map<String, PresetListEntry> lhm = new LinkedHashMap<String, PresetListEntry>();
        private boolean initialized = false;
        protected Usage usage;
        protected Object originalValue;
        private static ListCellRenderer RENDERER = new ListCellRenderer(){
            JLabel lbl = new JLabel();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                PresetListEntry presetListEntry = (PresetListEntry)object;
                if (!jList.isShowing() && presetListEntry.prefferedWidth != -1 && presetListEntry.prefferedHeight != -1) {
                    if (n == -1) {
                        this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, 10));
                    } else {
                        this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, presetListEntry.prefferedHeight));
                    }
                    return this.lbl;
                }
                this.lbl.setPreferredSize(null);
                if (bl) {
                    this.lbl.setBackground(jList.getSelectionBackground());
                    this.lbl.setForeground(jList.getSelectionForeground());
                } else {
                    this.lbl.setBackground(jList.getBackground());
                    this.lbl.setForeground(jList.getForeground());
                }
                this.lbl.setOpaque(true);
                this.lbl.setFont(this.lbl.getFont().deriveFont(0));
                this.lbl.setText("<html>" + presetListEntry.getListDisplay() + "</html>");
                this.lbl.setIcon(presetListEntry.getIcon());
                this.lbl.setEnabled(jList.isEnabled());
                presetListEntry.prefferedWidth = this.lbl.getPreferredSize().width;
                presetListEntry.prefferedHeight = this.lbl.getPreferredSize().height;
                if (n == -1) {
                    this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
                }
                return this.lbl;
            }
        };

        protected abstract Object getSelectedItem();

        protected abstract void addToPanelAnchor(JPanel var1, String var2);

        protected char getDelChar() {
            return this.delimiter.isEmpty() ? (char)';' : this.delimiter.charAt(0);
        }

        @Override
        public Collection<String> getValues() {
            this.initListEntries();
            return this.lhm.keySet();
        }

        public Collection<String> getDisplayValues() {
            this.initListEntries();
            return Utils.transform(this.lhm.values(), new Utils.Function<PresetListEntry, String>(){

                @Override
                public String apply(PresetListEntry presetListEntry) {
                    return presetListEntry.getDisplayValue(true);
                }
            });
        }

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            this.initListEntries();
            this.usage = TaggingPreset.determineTextUsage(collection, this.key);
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, new PresetListEntry(DIFFERENT));
            }
            jPanel.add((Component)new JLabel(I18n.tr("{0}:", this.locale_text)), GBC.std().insets(0, 0, 10, 0));
            this.addToPanelAnchor(jPanel, this.default_);
            return true;
        }

        private void initListEntries() {
            if (this.initialized) {
                this.lhm.remove(DIFFERENT);
                return;
            }
            if (this.lhm.isEmpty()) {
                this.initListEntriesFromAttributes();
            } else {
                if (this.values != null) {
                    System.err.println(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
                }
                if (this.display_values != null || this.locale_display_values != null) {
                    System.err.println(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
                }
                if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                    System.err.println(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
                }
                for (PresetListEntry presetListEntry : this.lhm.values()) {
                    if (presetListEntry.value_context != null) continue;
                    presetListEntry.value_context = this.values_context;
                }
            }
            if (this.locale_text == null) {
                this.locale_text = I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text));
            }
            this.initialized = true;
        }

        private String[] initListEntriesFromAttributes() {
            String[] stringArray;
            char c = this.getDelChar();
            String[] stringArray2 = TaggingPreset.splitEscaped(c, this.values);
            String string = Utils.firstNonNull(this.locale_display_values, this.display_values);
            String[] stringArray3 = string == null ? stringArray2 : TaggingPreset.splitEscaped(c, string);
            String string2 = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions);
            String[] stringArray4 = stringArray = string2 == null ? null : TaggingPreset.splitEscaped(c, string2);
            if (stringArray3.length != stringArray2.length) {
                System.err.println(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
                stringArray3 = stringArray2;
            }
            if (stringArray != null && stringArray.length != stringArray2.length) {
                System.err.println(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
                stringArray = null;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                PresetListEntry presetListEntry = new PresetListEntry(stringArray2[i]);
                String string3 = presetListEntry.locale_display_value = this.locale_display_values != null ? stringArray3[i] : I18n.trc(this.values_context, TaggingPreset.fixPresetString(stringArray3[i]));
                if (stringArray != null) {
                    presetListEntry.locale_short_description = this.locale_short_descriptions != null ? stringArray[i] : I18n.tr(TaggingPreset.fixPresetString(stringArray[i]), new Object[0]);
                }
                this.lhm.put(stringArray2[i], presetListEntry);
                stringArray3[i] = presetListEntry.getDisplayValue(true);
            }
            return stringArray3;
        }

        protected String getDisplayIfNull(String string) {
            return string;
        }

        @Override
        public void addCommands(List<Tag> list) {
            Object object = this.getSelectedItem();
            String string = object == null ? null : object.toString();
            String string2 = null;
            if (string == null) {
                string = this.getDisplayIfNull(string);
            }
            if (string != null) {
                for (String string3 : this.lhm.keySet()) {
                    String string4 = this.lhm.get(string3).toString();
                    if (string4 == null || !string4.equals(string)) continue;
                    string2 = string3;
                    break;
                }
                if (string2 == null) {
                    string2 = string;
                }
            } else {
                string2 = "";
            }
            string2 = string2.trim();
            if (this.originalValue == null ? string2.length() == 0 : string2.equals(this.originalValue.toString())) {
                return;
            }
            if (!"false".equals(this.use_last_as_default)) {
                lastValue.put(this.key, string2);
            }
            list.add(new Tag(this.key, string2));
        }

        public void addListEntry(PresetListEntry presetListEntry) {
            this.lhm.put(presetListEntry.value, presetListEntry);
        }

        public void addListEntries(Collection<PresetListEntry> collection) {
            for (PresetListEntry presetListEntry : collection) {
                this.addListEntry(presetListEntry);
            }
        }

        @Override
        boolean requestFocusInWindow() {
            return this.component.requestFocusInWindow();
        }

        protected ListCellRenderer getListCellRenderer() {
            return RENDERER;
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Check
    extends KeyedItem {
        public String locale_text;
        public String value_on = "yes";
        public String value_off = "no";
        public boolean default_ = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Usage usage = TaggingPreset.determineBooleanUsage(collection, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text)) : I18n.tr(TaggingPreset.fixPresetString(this.text), new Object[0]);
            }
            String string = null;
            Iterator<Object> iterator = usage.values.iterator();
            while (iterator.hasNext()) {
                String object;
                string = object = iterator.next();
            }
            if (usage.values.size() < 2 && (string == null || this.value_on.equals(string) || this.value_off.equals(string))) {
                if (this.def && !PROP_FILL_DEFAULT.get().booleanValue()) {
                    for (OsmPrimitive osmPrimitive : collection) {
                        if (!osmPrimitive.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = this.value_on.equals(string) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(string) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            jPanel.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> list) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            list.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            return Arrays.asList(this.value_on, this.value_off);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Text
    extends KeyedItem {
        public String locale_text;
        public String default_;
        public String originalValue;
        public String use_last_as_default = "false";
        public String auto_increment;
        public String length;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Serializable serializable;
            Usage usage = TaggingPreset.determineTextUsage(collection, this.key);
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            if (this.length != null && !this.length.isEmpty()) {
                autoCompletingTextField.setMaxChars(new Integer(this.length));
            }
            if (usage.unused()) {
                if (auto_increment_selected != 0 && this.auto_increment != null) {
                    try {
                        autoCompletingTextField.setText(Integer.toString(Integer.parseInt((String)lastValue.get(this.key)) + auto_increment_selected));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (!usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    if (!"false".equals(this.use_last_as_default) && lastValue.containsKey(this.key)) {
                        autoCompletingTextField.setText((String)lastValue.get(this.key));
                    } else {
                        autoCompletingTextField.setText(this.default_);
                    }
                } else {
                    autoCompletingTextField.setText("");
                }
                this.value = autoCompletingTextField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                autoCompletingTextField.setText(usage.getFirst());
                this.value = autoCompletingTextField;
                this.originalValue = usage.getFirst();
            } else {
                serializable = new JosmComboBox(usage.values.toArray());
                ((JComboBox)serializable).setEditable(true);
                ((JComboBox)serializable).setEditor(autoCompletingTextField);
                ((JComboBox)serializable).getEditor().setItem(DIFFERENT);
                this.value = serializable;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPreset.fixPresetString(this.text)) : I18n.tr(TaggingPreset.fixPresetString(this.text), new Object[0]);
            }
            if (this.auto_increment != null) {
                serializable = new ButtonGroup();
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel2.add((Component)this.value, GBC.std().fill(2));
                for (String string : this.auto_increment.split(",")) {
                    JToggleButton jToggleButton = new JToggleButton(string);
                    jToggleButton.setToolTipText(I18n.tr("Select auto-increment of {0} for this field", string));
                    jToggleButton.setMargin(new Insets(0, 0, 0, 0));
                    ((ButtonGroup)serializable).add(jToggleButton);
                    try {
                        final int n = NumberFormat.getIntegerInstance().parse(string.replace("+", "")).intValue();
                        if (auto_increment_selected == n) {
                            jToggleButton.setSelected(true);
                        }
                        jToggleButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                auto_increment_selected = n;
                            }
                        });
                        jPanel2.add((Component)jToggleButton, GBC.std());
                    }
                    catch (ParseException parseException) {
                        System.err.println("Cannot parse auto-increment value of '" + string + "' into an integer");
                    }
                }
                final JToggleButton jToggleButton = new JToggleButton("X");
                jToggleButton.setVisible(false);
                ((ButtonGroup)serializable).add(jToggleButton);
                JButton jButton = new JButton("X");
                jButton.setToolTipText(I18n.tr("Cancel auto-increment for this field", new Object[0]));
                jButton.setMargin(new Insets(0, 0, 0, 0));
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        auto_increment_selected = 0;
                        jToggleButton.setSelected(true);
                    }
                });
                jPanel2.add((Component)jButton, GBC.eol());
                this.value = jPanel2;
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        private static String getValue(Component component) {
            if (component instanceof JosmComboBox) {
                return ((JosmComboBox)component).getEditor().getItem().toString();
            }
            if (component instanceof JosmTextField) {
                return ((JosmTextField)component).getText();
            }
            if (component instanceof JPanel) {
                return Text.getValue(((JPanel)component).getComponent(0));
            }
            return null;
        }

        @Override
        public void addCommands(List<Tag> list) {
            String string = Text.getValue(this.value);
            if (string == null) {
                System.err.println("No 'last value' support for component " + this.value);
                return;
            }
            string = string.trim();
            if (!"false".equals(this.use_last_as_default) || this.auto_increment != null) {
                lastValue.put(this.key, string);
            }
            if (string.equals(this.originalValue) || this.originalValue == null && string.length() == 0) {
                return;
            }
            list.add(new Tag(this.key, string));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            if (this.default_ == null || this.default_.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singleton(this.default_);
        }
    }

    public static class PresetListEntry {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public String icon_size;
        public String locale_display_value;
        public String locale_short_description;
        private final File zipIcons = TaggingPreset.access$000();
        private int prefferedWidth = -1;
        private int prefferedHeight = -1;

        public String getListDisplay() {
            if (this.value.equals(DIFFERENT)) {
                return "<b>" + DIFFERENT.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</b>";
            }
            if (this.value.equals("")) {
                return "&nbsp;";
            }
            StringBuilder stringBuilder = new StringBuilder("<b>");
            stringBuilder.append(this.getDisplayValue(true));
            stringBuilder.append("</b>");
            if (this.getShortDescription(true) != null) {
                stringBuilder.append("<div style=\"width:300px; padding:0 0 5px 5px\">");
                stringBuilder.append(this.getShortDescription(true));
                stringBuilder.append("</div>");
            }
            return stringBuilder.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : TaggingPreset.loadImageIcon(this.icon, this.zipIcons, this.parseInteger(this.icon_size));
        }

        private Integer parseInteger(String string) {
            if (string == null || "".equals(string)) {
                return null;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public PresetListEntry() {
        }

        public PresetListEntry(String string) {
            this.value = string;
        }

        public String getDisplayValue(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value)) : Utils.firstNonNull(this.display_value, this.value);
        }

        public String getShortDescription(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (this.value.equals(DIFFERENT)) {
                return DIFFERENT;
            }
            return this.getDisplayValue(true).replaceAll("<.*>", "");
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.isEmpty();
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class KeyedItem
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String match = this.getDefaultMatch().getValue();

        public abstract MatchType getDefaultMatch();

        public abstract Collection<String> getValues();

        @Override
        Boolean matches(Map<String, String> map) {
            switch (MatchType.ofString(this.match)) {
                case NONE: {
                    return null;
                }
                case KEY: {
                    return map.containsKey(this.key) ? Boolean.valueOf(true) : null;
                }
                case KEY_REQUIRED: {
                    return map.containsKey(this.key);
                }
                case KEY_VALUE: {
                    return map.containsKey(this.key) && this.getValues().contains(map.get(this.key));
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Item {
        protected void initAutoCompletionField(AutoCompletingTextField autoCompletingTextField, String string) {
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            AutoCompletionList autoCompletionList = new AutoCompletionList();
            Main.main.getEditLayer().data.getAutoCompletionManager().populateWithTagValues(autoCompletionList, string);
            autoCompletingTextField.setAutoCompletionList(autoCompletionList);
        }

        abstract boolean addToPanel(JPanel var1, Collection<OsmPrimitive> var2);

        abstract void addCommands(List<Tag> var1);

        boolean requestFocusInWindow() {
            return false;
        }

        Boolean matches(Map<String, String> map) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue");

        private final String value;

        private MatchType(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String string) {
            for (MatchType matchType : EnumSet.allOf(MatchType.class)) {
                if (!matchType.getValue().equals(string)) continue;
                return matchType;
            }
            throw new IllegalArgumentException(string + " is not allowed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PresetType {
        NODE("Mf_node", "node"),
        WAY("Mf_way", "way"),
        RELATION("Mf_relation", "relation"),
        CLOSEDWAY("Mf_closedway", "closedway");

        private final String iconName;
        private final String name;

        private PresetType(String string2, String string3) {
            this.iconName = string2;
            this.name = string3;
        }

        public String getIconName() {
            return this.iconName;
        }

        public String getName() {
            return this.name;
        }

        public static PresetType forPrimitive(OsmPrimitive osmPrimitive) {
            return PresetType.forPrimitiveType(osmPrimitive.getDisplayType());
        }

        public static PresetType forPrimitiveType(OsmPrimitiveType osmPrimitiveType) {
            switch (osmPrimitiveType) {
                case NODE: {
                    return NODE;
                }
                case WAY: {
                    return WAY;
                }
                case CLOSEDWAY: {
                    return CLOSEDWAY;
                }
                case RELATION: 
                case MULTIPOLYGON: {
                    return RELATION;
                }
            }
            throw new IllegalArgumentException("Unexpected primitive type: " + (Object)((Object)osmPrimitiveType));
        }

        public static PresetType fromString(String string) {
            for (PresetType presetType : PresetType.values()) {
                if (!presetType.getName().equals(string)) continue;
                return presetType;
            }
            return null;
        }
    }
}

