/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultikeyActionsHandler;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToMarkerActions {
    private static JumpToNextMarker jumpToNextMarkerAction;
    private static JumpToPreviousMarker jumpToPreviousMarkerAction;

    public static void initialize() {
        jumpToNextMarkerAction = new JumpToNextMarker(null);
        jumpToPreviousMarkerAction = new JumpToPreviousMarker(null);
        MultikeyActionsHandler.getInstance().addAction(jumpToNextMarkerAction);
        MultikeyActionsHandler.getInstance().addAction(jumpToPreviousMarkerAction);
    }

    public static void unregisterActions() {
        MultikeyActionsHandler.getInstance().removeAction(jumpToNextMarkerAction);
        MultikeyActionsHandler.getInstance().removeAction(jumpToPreviousMarkerAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JumpToPreviousMarker
    extends AbstractAction
    implements MultikeyShortcutAction {
        private WeakReference<Layer> lastLayer;
        private final Layer layer;
        private Shortcut multikeyShortcut;

        public JumpToPreviousMarker(JumpToMarkerLayer jumpToMarkerLayer) {
            this.layer = (Layer)((Object)jumpToMarkerLayer);
            this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:previousMarker", I18n.tr("Multikey: {0}", I18n.tr("Previos marker", new Object[0])), 80, 5008);
            this.multikeyShortcut.setAccelerator(this);
            this.putValue("ShortDescription", I18n.tr("Jump to previous marker", new Object[0]));
            this.putValue("Name", I18n.tr("Jump to previous marker", new Object[0]));
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.execute(this.layer);
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            Layer layer = LayerListDialog.getLayerForIndex(n);
            if (layer != null) {
                if (layer instanceof JumpToMarkerLayer) {
                    this.execute(layer);
                }
            } else if (bl && this.lastLayer != null && LayerListDialog.isLayerValid(layer = (Layer)this.lastLayer.get())) {
                this.execute(layer);
            }
        }

        private void execute(Layer layer) {
            ((JumpToMarkerLayer)((Object)layer)).jumpToPreviousMarker();
            this.lastLayer = new WeakReference<Layer>(layer);
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(JumpToMarkerLayer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.lastLayer != null) {
                return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class JumpToNextMarker
    extends AbstractAction
    implements MultikeyShortcutAction {
        private final Layer layer;
        private WeakReference<Layer> lastLayer;
        private Shortcut multikeyShortcut = Shortcut.registerShortcut("core_multikey:nextMarker", I18n.tr("Multikey: {0}", I18n.tr("Next marker", new Object[0])), 74, 5008);

        public JumpToNextMarker(JumpToMarkerLayer jumpToMarkerLayer) {
            this.multikeyShortcut.setAccelerator(this);
            this.putValue("ShortDescription", I18n.tr("Jump to next marker", new Object[0]));
            this.putValue("Name", I18n.tr("Jump to next marker", new Object[0]));
            this.layer = (Layer)((Object)jumpToMarkerLayer);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.execute(this.layer);
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            Layer layer = LayerListDialog.getLayerForIndex(n);
            if (layer != null) {
                if (layer instanceof JumpToMarkerLayer) {
                    this.execute(layer);
                }
            } else if (bl && this.lastLayer != null && LayerListDialog.isLayerValid(layer = (Layer)this.lastLayer.get())) {
                this.execute(layer);
            }
        }

        private void execute(Layer layer) {
            ((JumpToMarkerLayer)((Object)layer)).jumpToNextMarker();
            this.lastLayer = new WeakReference<Layer>(layer);
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(JumpToMarkerLayer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.lastLayer != null) {
                return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
            }
            return null;
        }
    }

    public static interface JumpToMarkerLayer {
        public void jumpToNextMarker();

        public void jumpToPreviousMarker();
    }
}

