/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String string) {
        super(string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchHelpTopicContent(String string, boolean bl) throws HelpContentReaderException {
        String string2;
        if (string == null) {
            throw new MissingHelpContentException();
        }
        HttpURLConnection httpURLConnection = null;
        BufferedReader bufferedReader = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = Utils.openHttpConnection(uRL);
            httpURLConnection.connect();
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));
            string2 = this.prepareHelpContent(bufferedReader, bl, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                throw new HelpContentReaderException(malformedURLException);
                catch (IOException iOException) {
                    HelpContentReaderException helpContentReaderException = new HelpContentReaderException(iOException);
                    if (httpURLConnection == null) throw helpContentReaderException;
                    try {
                        helpContentReaderException.setResponseCode(httpURLConnection.getResponseCode());
                        throw helpContentReaderException;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    throw helpContentReaderException;
                }
            }
            catch (Throwable throwable) {
                Utils.close(bufferedReader);
                throw throwable;
            }
        }
        Utils.close(bufferedReader);
        return string2;
    }

    protected String prepareHelpContent(BufferedReader bufferedReader, boolean bl, URL uRL) throws HelpContentReaderException {
        String string = "";
        try {
            string = this.readFromTrac(bufferedReader, uRL);
        }
        catch (IOException iOException) {
            throw new HelpContentReaderException(iOException);
        }
        if (bl && string.isEmpty()) {
            throw new MissingHelpContentException();
        }
        return string;
    }
}

