/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.Map_Rectifier_WMSmenuAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryMenu
extends JMenu
implements MapView.LayerChangeListener {
    private Action offsetAction = new JosmAction(I18n.tr("Imagery offset", new Object[0]), "mapmode/adjustimg", I18n.tr("Adjust imagery offset", new Object[0]), null, false, false){
        {
            this.putValue("toolbar", "imagery-offset");
            Main.toolbar.register(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<ImageryLayer> list = Main.map.mapView.getLayersOfType(ImageryLayer.class);
            if (list.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Component component = null;
            if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (list.size() == 1) {
                JComponent jComponent = list.get(0).getOffsetMenuItem(jPopupMenu);
                if (jComponent instanceof JMenuItem) {
                    ((JMenuItem)jComponent).getAction().actionPerformed(actionEvent);
                } else {
                    if (component == null) {
                        return;
                    }
                    jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
                }
                return;
            }
            if (component == null) {
                return;
            }
            for (ImageryLayer imageryLayer : list) {
                JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
                jMenuItem.setText(imageryLayer.getName());
                jMenuItem.setIcon(imageryLayer.getIcon());
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
        }
    };
    private JMenuItem singleOffset;
    private JMenuItem offsetMenuItem = this.singleOffset = new JMenuItem(this.offsetAction);
    private Map_Rectifier_WMSmenuAction rectaction = new Map_Rectifier_WMSmenuAction();
    private List<Object> dynamicItems = new ArrayList<Object>(20);

    public ImageryMenu() {
        super(I18n.tr("Imagery", new Object[0]));
        this.setupMenuScroller();
        MapView.addLayerChangeListener(this);
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                ImageryMenu.this.refreshImageryMenu();
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private void setupMenuScroller() {
        int n = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n2 = this.singleOffset.getPreferredSize().height;
        MenuScroller.setScrollerFor(this, n / n2 - 1);
    }

    public void refreshImageryMenu() {
        this.removeDynamicItems();
        this.addDynamic(this.offsetMenuItem);
        this.addDynamicSeparator();
        for (ImageryInfo object : ImageryLayerInfo.instance.getLayers()) {
            this.addDynamic(new AddImageryLayerAction(object));
        }
        if (Main.isDisplayingMapView()) {
            MapView mapView = Main.map.mapView;
            LatLon latLon = mapView.getProjection().eastNorth2latlon(mapView.getCenter());
            HashSet<ImageryInfo> hashSet = new HashSet<ImageryInfo>();
            for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getDefaultLayers()) {
                if (imageryInfo.getBounds() == null || !imageryInfo.getBounds().contains(latLon)) continue;
                hashSet.add(imageryInfo);
            }
            hashSet.removeAll(ImageryLayerInfo.instance.getLayers());
            Iterator<ImageryInfo> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                List<Shape> list = iterator.next().getBounds().getShapes();
                if (list == null || list.isEmpty()) continue;
                boolean bl = false;
                Iterator<Shape> iterator2 = list.iterator();
                while (iterator2.hasNext() && !bl) {
                    bl = iterator2.next().contains(latLon);
                }
                if (bl) continue;
                iterator.remove();
            }
            if (!hashSet.isEmpty()) {
                this.addDynamicSeparator();
                for (ImageryInfo imageryInfo : hashSet) {
                    this.addDynamic(new AddImageryLayerAction(imageryInfo));
                }
            }
        }
        this.addDynamicSeparator();
        this.addDynamic(this.rectaction);
    }

    private JMenuItem getNewOffsetMenu() {
        if (Main.map == null || Main.map.mapView == null) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        List<ImageryLayer> list = Main.map.mapView.getLayersOfType(ImageryLayer.class);
        if (list.isEmpty()) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        this.offsetAction.setEnabled(true);
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset")){

            public MenuElement[] getSubElements() {
                return new MenuElement[0];
            }
        };
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        jMenu.setAction(this.offsetAction);
        if (list.size() == 1) {
            return (JMenuItem)list.get(0).getOffsetMenuItem(jMenu);
        }
        for (ImageryLayer imageryLayer : list) {
            JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
            jMenuItem.setText(imageryLayer.getName());
            jMenuItem.setIcon(imageryLayer.getIcon());
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void refreshOffsetMenu() {
        this.offsetMenuItem = this.getNewOffsetMenu();
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
        if (layer instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    private void removeDynamicItems() {
        for (Object object : this.dynamicItems) {
            if (object instanceof JMenuItem) {
                this.remove((JMenuItem)object);
            }
            if (object instanceof MenuComponent) {
                this.remove((MenuComponent)object);
            }
            if (!(object instanceof Component)) continue;
            this.remove((Component)object);
        }
        this.dynamicItems.clear();
    }

    private void addDynamicSeparator() {
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        this.dynamicItems.add(separator);
        this.add(separator);
    }

    private void addDynamic(Action action) {
        this.dynamicItems.add(this.add(action));
    }

    private void addDynamic(JMenuItem jMenuItem) {
        this.dynamicItems.add(this.add(jMenuItem));
    }
}

