/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.I18n;

public class WayConnectedToArea
extends Test {
    public WayConnectedToArea() {
        super(I18n.tr("Way connected to Area", new Object[0]), I18n.tr("Checks for ways connected to areas.", new Object[0]));
    }

    public void visit(Way way) {
        if (!way.isUsable() || way.isClosed() || !way.hasKey("highway")) {
            return;
        }
        boolean bl = false;
        List<OsmPrimitive> list = way.firstNode().getReferrers();
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive == way || !osmPrimitive.hasKey("highway")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (OsmPrimitive osmPrimitive : list) {
                this.testForError(way, way.firstNode(), osmPrimitive);
            }
        }
        bl = false;
        list = way.lastNode().getReferrers();
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive == way || !osmPrimitive.hasKey("highway")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (OsmPrimitive osmPrimitive : list) {
                this.testForError(way, way.lastNode(), osmPrimitive);
            }
        }
    }

    private void testForError(Way way, Node node, OsmPrimitive osmPrimitive) {
        if (this.isArea(osmPrimitive)) {
            this.addError(way, node, osmPrimitive);
        } else {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || !osmPrimitive2.hasTag("type", "multipolygon") || !this.isArea(osmPrimitive2)) continue;
                this.addError(way, node, osmPrimitive);
                break;
            }
        }
    }

    private boolean isArea(OsmPrimitive osmPrimitive) {
        return (osmPrimitive.hasKey("landuse") || osmPrimitive.hasKey("natural")) && ElemStyles.hasAreaElemStyle(osmPrimitive, false);
    }

    private void addError(Way way, Node node, OsmPrimitive osmPrimitive) {
        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Way terminates on Area", new Object[0]), 2301, Arrays.asList(way, osmPrimitive), Arrays.asList(node)));
    }
}

