/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.Collections;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class DuplicatedWayNodes
extends Test {
    protected static final int DUPLICATE_WAY_NODE = 501;

    public DuplicatedWayNodes() {
        super(I18n.tr("Duplicated way nodes", new Object[0]), I18n.tr("Checks for ways with identical consecutive nodes.", new Object[0]));
    }

    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        Node node = null;
        for (Node node2 : way.getNodes()) {
            if (node == null) {
                node = node2;
                continue;
            }
            if (node == node2) {
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Duplicated way nodes", new Object[0]), 501, Arrays.asList(way), Arrays.asList(node2)));
                break;
            }
            node = node2;
        }
    }

    public Command fixError(TestError testError) {
        Way way = (Way)testError.getPrimitives().iterator().next();
        Way way2 = new Way(way);
        way2.setNodes(null);
        Node node = null;
        for (Node node2 : way.getNodes()) {
            if (node == null) {
                way2.addNode(node2);
            } else if (node2 != node) {
                way2.addNode(node2);
            }
            node = node2;
        }
        if (way2.getNodesCount() < 2) {
            return this.deletePrimitivesIfNeeded(Collections.singleton(way));
        }
        return new ChangeCommand(way, way2);
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicatedWayNodes;
    }
}

