/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveData
extends AbstractPrimitive {
    public PrimitiveData() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public PrimitiveData(PrimitiveData primitiveData) {
        this.cloneFrom(primitiveData);
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public void setIncomplete(boolean bl) {
        super.setIncomplete(bl);
    }

    public abstract PrimitiveData makeCopy();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append(Arrays.toString(this.keys)).append(this.getFlagsAsString());
        return stringBuilder.toString();
    }

    public static <T extends PrimitiveData> List<T> getFilteredList(Collection<T> collection, OsmPrimitiveType osmPrimitiveType) {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        for (PrimitiveData primitiveData : collection) {
            if (!osmPrimitiveType.getDataClass().isInstance(primitiveData)) continue;
            arrayList.add(primitiveData);
        }
        return arrayList;
    }

    @Override
    protected final void keysChangedImpl(Map<String, String> map) {
    }

    @Override
    public abstract OsmPrimitiveType getType();
}

