/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    public static final int JOSM_UNKNOWN_VERSION = 0;
    private static Version instance;
    private int version;
    private String releaseDescription;
    private String time;
    private String buildName;
    private boolean isLocalBuild;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResourceFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = null;
        try {
            BufferedReader bufferedReader = Utils.openURLReader(uRL);
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2).append("\n");
                    string2 = bufferedReader.readLine();
                }
            }
            finally {
                Utils.close(bufferedReader);
            }
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            System.err.println(I18n.tr("Failed to load resource ''{0}'', error is {1}.", uRL.toString(), iOException.toString()));
            iOException.printStackTrace();
        }
        return string;
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
            instance.init();
        }
        return instance;
    }

    protected HashMap<String, String> parseManifestStyleFormattedString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            return hashMap;
        }
        Pattern pattern = Pattern.compile("^([^:]+):(.*)$");
        for (String string2 : string.split("\n")) {
            Matcher matcher;
            if (string2 == null || string2.trim().equals("") || string2.matches("^\\s*#.*$") || !(matcher = pattern.matcher(string2)).matches()) continue;
            hashMap.put(matcher.group(1), matcher.group(2));
        }
        return hashMap;
    }

    protected void initFromRevisionInfo(String string) {
        if (string == null) {
            this.releaseDescription = I18n.tr("UNKNOWN", new Object[0]);
            this.version = 0;
            this.time = null;
            return;
        }
        HashMap<String, String> hashMap = this.parseManifestStyleFormattedString(string);
        String string2 = hashMap.get("Revision");
        if (string2 != null) {
            string2 = string2.trim();
            try {
                this.version = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.version = 0;
                System.err.println(I18n.tr("Warning: unexpected JOSM version number in revision file, value is ''{0}''", string2));
            }
        } else {
            this.version = 0;
        }
        this.time = hashMap.get("Last Changed Date");
        if (this.time == null) {
            this.time = hashMap.get("Build-Date");
        }
        this.isLocalBuild = false;
        string2 = hashMap.get("Is-Local-Build");
        if (string2 != null && string2.trim().toLowerCase().equals("true")) {
            this.isLocalBuild = true;
        }
        this.buildName = null;
        string2 = hashMap.get("Build-Name");
        if (string2 != null && !string2.trim().isEmpty()) {
            this.buildName = string2.trim();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
        this.releaseDescription = stringBuffer.toString();
    }

    public void init() {
        URL uRL = Main.class.getResource("/REVISION");
        if (uRL == null) {
            System.err.println(I18n.tr("Warning: the revision file ''/REVISION'' is missing.", new Object[0]));
            this.version = 0;
            this.releaseDescription = "";
            return;
        }
        this.initFromRevisionInfo(Version.loadResourceFile(uRL));
    }

    public String getVersionString() {
        return this.version == 0 ? I18n.tr("UNKNOWN", new Object[0]) : Integer.toString(this.version);
    }

    public String getReleaseAttributes() {
        return this.releaseDescription;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLocalBuild() {
        return this.isLocalBuild;
    }

    public String getAgentString() {
        String string;
        int n = this.getVersion();
        String string2 = string = n == 0 ? "UNKNOWN" : Integer.toString(n);
        if (this.buildName != null) {
            string = string + " " + this.buildName;
        }
        if (this.isLocalBuild() && n != 0) {
            string = string + " SVN";
        }
        return "JOSM/1.5 (" + string + " " + LanguageInfo.getJOSMLocaleCode() + ") " + Main.platform.getOSDescription();
    }

    public String getFullAgentString() {
        return this.getAgentString() + " Java/" + System.getProperty("java.version");
    }
}

