/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction
implements MouseListener {
    private JosmTextField url = new JosmTextField();
    private JosmTextField lat = new JosmTextField();
    private JosmTextField lon = new JosmTextField();
    private JosmTextField zm = new JosmTextField();
    private double zoomFactor = 0.0;

    public JumpToAction() {
        super(I18n.tr("Jump To Position", new Object[0]), null, I18n.tr("Opens a dialog that allows to jump to a specific location", new Object[0]), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump To Position", new Object[0])), 74, 5006), false);
        this.putValue("toolbar", "action/jumpto");
        Main.toolbar.register(this);
    }

    public void showJumpToDialog() {
        MapView mapView = Main.map.mapView;
        if (mapView == null) {
            return;
        }
        LatLon latLon = mapView.getProjection().eastNorth2latlon(mapView.getCenter());
        this.lat.setText(Double.toString(latLon.lat()));
        this.lon.setText(Double.toString(latLon.lon()));
        double d = mapView.getDist100Pixel();
        this.zoomFactor = 1.0 / d;
        this.zm.setText(Long.toString(Math.round(d * 100.0) / 100L));
        this.updateUrl(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.", new Object[0]) + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org", new Object[0]) + "<br>" + "</html>"), "North");
        class OsmLonLatListener
        implements DocumentListener {
            OsmLonLatListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.updateUrl(false);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.updateUrl(false);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.updateUrl(false);
            }
        }
        OsmLonLatListener osmLonLatListener = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(osmLonLatListener);
        this.lon.getDocument().addDocumentListener(osmLonLatListener);
        this.zm.getDocument().addDocumentListener(osmLonLatListener);
        class OsmURLListener
        implements DocumentListener {
            OsmURLListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.parseURL();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.parseURL();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JumpToAction.this.parseURL();
            }
        }
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel(I18n.tr("Latitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lat, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Longitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lon, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Zoom (in metres)", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.zm, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("URL", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.url, GBC.eol().fill(2));
        Object[] objectArray = new Object[]{I18n.tr("Jump there", new Object[0]), I18n.tr("Cancel", new Object[0])};
        LatLon latLon2 = null;
        double d2 = 100.0;
        while (latLon2 == null) {
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Jump to Position", new Object[0]), 2, -1, null, objectArray, objectArray[0]);
            if (n != 0) {
                return;
            }
            try {
                d2 = Double.parseDouble(this.zm.getText());
                latLon2 = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check.", new Object[0]), I18n.tr("Unable to parse Lon/Lat", new Object[0]), 0);
            }
        }
        mapView.zoomToFactor(mapView.getProjection().latlon2eastNorth(latLon2), this.zoomFactor * d2);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        Bounds bounds = OsmUrlToBounds.parse(this.url.getText());
        if (bounds != null) {
            String[] stringArray;
            this.lat.setText(Double.toString((bounds.getMin().lat() + bounds.getMax().lat()) / 2.0));
            this.lon.setText(Double.toString((bounds.getMin().lon() + bounds.getMax().lon()) / 2.0));
            int n = 16;
            for (String string : stringArray = this.url.getText().substring(this.url.getText().indexOf(63) + 1).split("&")) {
                int n2 = string.indexOf(61);
                if (n2 == -1 || !string.substring(0, n2).equalsIgnoreCase("zoom")) continue;
                n = Integer.parseInt(string.substring(n2 + 1));
                break;
            }
            this.zm.setText(Double.toString(Math.round(1.0E7 * Math.pow(2.0, -1 * n))));
        }
    }

    private void updateUrl(boolean bl) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || bl)) {
            return;
        }
        try {
            double d = Double.parseDouble(this.lat.getText());
            double d2 = Double.parseDouble(this.lon.getText());
            double d3 = Double.parseDouble(this.zm.getText());
            int n = 18;
            if (d3 > 0.0) {
                n = (int)Math.round(-1.0 * Math.log(d3 / 1.0E7) / Math.log(2.0));
            }
            int n2 = (int)Math.pow(10.0, n / 3);
            d = Math.round(d * (double)n2);
            d2 = Math.round(d2 * (double)n2);
            this.url.setText("http://www.openstreetmap.org/?lat=" + (d /= (double)n2) + "&lon=" + (d2 /= (double)n2) + "&zoom=" + n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.showJumpToDialog();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.showJumpToDialog();
    }
}

