/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.download.DownloadObjectDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadPrimitiveAction
extends JosmAction {
    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object...", new Object[0]), "downloadprimitive", I18n.tr("Download OSM object by ID.", new Object[0]), Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download object...", new Object[0])), 79, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DownloadObjectDialog downloadObjectDialog = new DownloadObjectDialog();
        if (downloadObjectDialog.showDialog().getValue() != 1) {
            return;
        }
        DownloadPrimitiveAction.processItems(downloadObjectDialog.isNewLayerRequested(), downloadObjectDialog.getOsmIds(), downloadObjectDialog.isReferrersRequested(), downloadObjectDialog.isFullRelationRequested());
    }

    public static void processItems(boolean bl, final List<PrimitiveId> list, boolean bl2, boolean bl3) {
        OsmDataLayer osmDataLayer = DownloadPrimitiveAction.getEditLayer();
        if (osmDataLayer == null || bl) {
            osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
        }
        final DownloadPrimitivesTask downloadPrimitivesTask = new DownloadPrimitivesTask(osmDataLayer, list, bl3);
        Main.worker.submit(downloadPrimitivesTask);
        if (bl2) {
            for (PrimitiveId primitiveId : list) {
                Main.worker.submit(new DownloadReferrersTask(osmDataLayer, primitiveId));
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                final Set<PrimitiveId> set = downloadPrimitivesTask.getMissingPrimitives();
                if (set != null && !set.isEmpty()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DownloadPrimitiveAction.reportProblemDialog(set, I18n.trn("Object could not be downloaded", "Some objects could not be downloaded", set.size(), new Object[0]), I18n.trn("One object could not be downloaded.<br>", "{0} objects could not be downloaded.<br>", set.size(), set.size()) + I18n.tr("The server replied with response code 404.<br>This usually means, the server does not know an object with the requested id.", new Object[0]), I18n.tr("missing objects:", new Object[0]), 0).showDialog();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                final TreeSet<PrimitiveId> treeSet = new TreeSet<PrimitiveId>();
                DataSet dataSet = JosmAction.getCurrentDataSet();
                for (PrimitiveId primitiveId : list) {
                    OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveId);
                    if (osmPrimitive == null || !osmPrimitive.isDeleted()) continue;
                    treeSet.add(primitiveId);
                }
                if (!treeSet.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DownloadPrimitiveAction.reportProblemDialog(treeSet, I18n.trn("Object deleted", "Objects deleted", treeSet.size(), new Object[0]), I18n.trn("One downloaded object is deleted.", "{0} downloaded objects are deleted.", treeSet.size(), treeSet.size()), null, 2).showDialog();
                        }
                    });
                }
            }
        };
        Main.worker.submit(runnable);
    }

    private static ExtendedDialog reportProblemDialog(Set<PrimitiveId> set, String string, String string2, String string3, int n) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new HtmlPanel(string2), GBC.eop());
        if (string3 != null) {
            jComponent = new JLabel(string3);
            jComponent.setFont(jComponent.getFont().deriveFont(0));
            jPanel.add((Component)jComponent, GBC.eol());
        }
        jComponent = new JosmTextArea();
        ((JTextArea)jComponent).setFont(new Font("Monospaced", jComponent.getFont().getStyle(), jComponent.getFont().getSize()));
        ((JTextComponent)jComponent).setEditable(false);
        jComponent.setBackground(jPanel.getBackground());
        ((JTextArea)jComponent).setColumns(40);
        ((JTextArea)jComponent).setRows(1);
        ((JTextComponent)jComponent).setText(Utils.join(", ", set));
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jPanel.add((Component)jScrollPane, GBC.eop().weight(1.0, 0.0).fill(2));
        return new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Ok", new Object[0])}).setButtonIcons(new String[]{"ok"}).setIcon(n).setContent(jPanel, false);
    }
}

