/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowserModel
extends Observable
implements MapView.LayerChangeListener,
DataSetListener {
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private HistoryOsmPrimitive latest;
    private VersionTableModel versionTableModel = new VersionTableModel();
    private TagTableModel currentTagTableModel = new TagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private TagTableModel referenceTagTableModel = new TagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private RelationMemberTableModel currentRelationMemberTableModel;
    private RelationMemberTableModel referenceRelationMemberTableModel;
    private DiffTableModel referenceNodeListTableModel = new DiffTableModel();
    private DiffTableModel currentNodeListTableModel = new DiffTableModel();

    public HistoryBrowserModel() {
        this.currentRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
        this.referenceRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
        if (this.getEditLayer() != null) {
            this.getEditLayer().data.addDataSetListener(this);
        }
        MapView.addLayerChangeListener(this);
    }

    public HistoryBrowserModel(History history) {
        this();
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.setHistory(history);
    }

    protected OsmDataLayer getEditLayer() {
        try {
            return Main.map.mapView.getEditLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public History getHistory() {
        return this.history;
    }

    protected boolean hasNewNodes(Way way) {
        for (Node node : way.getNodes()) {
            if (!node.isNew()) continue;
            return true;
        }
        return false;
    }

    protected boolean canShowAsLatest(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        if (osmPrimitive.isNew() || !osmPrimitive.isUsable()) {
            return false;
        }
        try {
            HistoryOsmPrimitive.forOsmPrimitive(osmPrimitive);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.history == null) {
            return false;
        }
        if (this.history.getByVersion(osmPrimitive.getVersion()) != null) {
            return osmPrimitive.isModified();
        }
        return this.history.getLatest().getVersion() <= (long)osmPrimitive.getVersion();
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            OsmPrimitive osmPrimitive;
            HistoryOsmPrimitive historyOsmPrimitive = null;
            if (this.getEditLayer() != null && this.canShowAsLatest(osmPrimitive = this.getEditLayer().data.getPrimitiveById(history.getId(), history.getType()))) {
                historyOsmPrimitive = new HistoryPrimitiveBuilder().build(osmPrimitive);
            }
            if (historyOsmPrimitive == null) {
                this.current = history.getLatest();
                int n = history.getNumVersions() - 2;
                this.reference = n < 0 ? history.getEarliest() : history.get(n);
            } else {
                this.reference = history.getLatest();
                this.current = historyOsmPrimitive;
            }
            this.setLatest(historyOsmPrimitive);
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    protected void fireModelChange() {
        this.initNodeListTableModels();
        this.setChanged();
        this.notifyObservers();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    protected void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    protected void initNodeListTableModels() {
        if (this.current.getType() != OsmPrimitiveType.WAY || this.reference.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        TwoColumnDiff twoColumnDiff = new TwoColumnDiff(((HistoryWay)this.reference).getNodes().toArray(), ((HistoryWay)this.current).getNodes().toArray());
        this.referenceNodeListTableModel.setRows(twoColumnDiff.referenceDiff);
        this.currentNodeListTableModel.setRows(twoColumnDiff.currentDiff);
        this.referenceNodeListTableModel.fireTableDataChanged();
        this.currentNodeListTableModel.fireTableDataChanged();
    }

    protected void initMemberListTableModels() {
        this.currentRelationMemberTableModel.fireTableDataChanged();
        this.referenceRelationMemberTableModel.fireTableDataChanged();
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceTagTableModel;
        }
        return null;
    }

    public DiffTableModel getNodeListTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceNodeListTableModel;
        }
        return null;
    }

    public RelationMemberTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceRelationMemberTableModel;
        }
        return null;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive historyOsmPrimitive) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "reference");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.reference = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive historyOsmPrimitive) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "current");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive.", new Object[0]));
        }
        if (historyOsmPrimitive.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", historyOsmPrimitive.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive historyOsmPrimitive2 = this.history.getByVersion(historyOsmPrimitive.getVersion());
        if (historyOsmPrimitive2 == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", historyOsmPrimitive.getVersion()));
        }
        this.current = historyOsmPrimitive;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "type");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public boolean isLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            return false;
        }
        return historyOsmPrimitive == this.latest;
    }

    protected void setLatest(HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive == null) {
            if (this.current == this.latest) {
                this.current = this.history.getLatest();
            }
            if (this.reference == this.latest) {
                this.current = this.history.getLatest();
            }
            this.latest = null;
        } else {
            if (this.current == this.latest) {
                this.current = historyOsmPrimitive;
            }
            if (this.reference == this.latest) {
                this.reference = historyOsmPrimitive;
            }
            this.latest = historyOsmPrimitive;
        }
        this.fireModelChange();
    }

    public void unlinkAsListener() {
        if (this.getEditLayer() != null) {
            this.getEditLayer().data.removeDataSetListener(this);
        }
        MapView.removeLayerChangeListener(this);
    }

    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
        Node node = nodeMovedEvent.getNode();
        if (!node.isNew() && node.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(node));
        }
    }

    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesAddedEvent.getPrimitives()) {
            if (!this.canShowAsLatest(osmPrimitive)) continue;
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesRemovedEvent.getPrimitives()) {
            if (osmPrimitive.isNew() || osmPrimitive.getId() != this.history.getId()) continue;
            this.setLatest(null);
        }
    }

    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        Relation relation = relationMembersChangedEvent.getRelation();
        if (!relation.isNew() && relation.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(relation));
        }
    }

    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        OsmPrimitive osmPrimitive = tagsChangedEvent.getPrimitive();
        if (!osmPrimitive.isNew() && osmPrimitive.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(osmPrimitive));
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        Way way = wayNodesChangedEvent.getChangedWay();
        if (!way.isNew() && way.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(way));
        }
    }

    public void dataChanged(DataChangedEvent dataChangedEvent) {
        OsmPrimitive osmPrimitive = dataChangedEvent.getDataset().getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
        OsmDataLayer osmDataLayer;
        if (layer != null && layer instanceof OsmDataLayer) {
            osmDataLayer = (OsmDataLayer)layer;
            osmDataLayer.data.removeDataSetListener(this);
        }
        if (layer2 == null || !(layer2 instanceof OsmDataLayer)) {
            this.latest = null;
            this.fireModelChange();
            return;
        }
        osmDataLayer = (OsmDataLayer)layer2;
        osmDataLayer.data.addDataSetListener(this);
        OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive historyOsmPrimitive = this.canShowAsLatest(osmPrimitive) ? new HistoryPrimitiveBuilder().build(osmPrimitive) : null;
        this.setLatest(historyOsmPrimitive);
        this.fireModelChange();
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
    }

    static class HistoryPrimitiveBuilder
    extends AbstractVisitor {
        private HistoryOsmPrimitive clone;

        HistoryPrimitiveBuilder() {
        }

        public void visit(Node node) {
            this.clone = new HistoryNode(node.getId(), node.getVersion(), node.isVisible(), this.getCurrentUser(), 0L, null, node.getCoor(), false);
            this.clone.setTags(node.getKeys());
        }

        public void visit(Relation relation) {
            this.clone = new HistoryRelation(relation.getId(), (long)relation.getVersion(), relation.isVisible(), this.getCurrentUser(), 0L, null, false);
            this.clone.setTags(relation.getKeys());
            HistoryRelation historyRelation = (HistoryRelation)this.clone;
            for (RelationMember relationMember : relation.getMembers()) {
                historyRelation.addMember(new RelationMemberData(relationMember.getRole(), relationMember.getType(), relationMember.getUniqueId()));
            }
        }

        public void visit(Way way) {
            this.clone = new HistoryWay(way.getId(), (long)way.getVersion(), way.isVisible(), this.getCurrentUser(), 0L, null, false);
            this.clone.setTags(way.getKeys());
            for (Node node : way.getNodes()) {
                ((HistoryWay)this.clone).addNode(node.getUniqueId());
            }
        }

        private User getCurrentUser() {
            UserInfo userInfo = JosmUserIdentityManager.getInstance().getUserInfo();
            return userInfo == null ? User.getAnonymous() : User.createOsmUser(userInfo.getId(), userInfo.getDisplayName());
        }

        public HistoryOsmPrimitive build(OsmPrimitive osmPrimitive) {
            osmPrimitive.visit(this);
            return this.clone;
        }
    }

    public class RelationMemberTableModel
    extends AbstractTableModel {
        private PointInTimeType pointInTimeType;

        private RelationMemberTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
        }

        public int getRowCount() {
            int n = 0;
            if (HistoryBrowserModel.this.current != null && HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = ((HistoryRelation)HistoryBrowserModel.this.current).getNumMembers();
            }
            if (HistoryBrowserModel.this.reference != null && HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = Math.max(n, ((HistoryRelation)HistoryBrowserModel.this.reference).getNumMembers());
            }
            return n;
        }

        protected HistoryRelation getRelation() {
            if (this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        protected HistoryRelation getOppositeRelation() {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            HistoryRelation historyRelation = this.getRelation();
            if (historyRelation == null) {
                return null;
            }
            if (n >= historyRelation.getNumMembers()) {
                return null;
            }
            return historyRelation.getMembers().get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean isSameInOppositeWay(int n) {
            HistoryRelation historyRelation = this.getRelation();
            HistoryRelation historyRelation2 = this.getOppositeRelation();
            if (historyRelation == null || historyRelation2 == null) {
                return false;
            }
            if (n >= historyRelation2.getNumMembers()) {
                return false;
            }
            return historyRelation.getMembers().get(n).getMemberId() == historyRelation2.getMembers().get(n).getMemberId() && historyRelation.getMembers().get(n).getRole().equals(historyRelation2.getMembers().get(n).getRole());
        }

        public boolean isInOppositeWay(int n) {
            HistoryRelation historyRelation = this.getRelation();
            HistoryRelation historyRelation2 = this.getOppositeRelation();
            if (historyRelation == null || historyRelation2 == null) {
                return false;
            }
            return historyRelation2.getMembers().contains(historyRelation.getMembers().get(n));
        }

        public int getColumnCount() {
            return 1;
        }
    }

    public class TagTableModel
    extends AbstractTableModel {
        private ArrayList<String> keys;
        private PointInTimeType pointInTimeType;

        protected void initKeyList() {
            HashSet<String> hashSet = new HashSet<String>();
            if (HistoryBrowserModel.this.current != null) {
                hashSet.addAll(HistoryBrowserModel.this.current.getTags().keySet());
            }
            if (HistoryBrowserModel.this.reference != null) {
                hashSet.addAll(HistoryBrowserModel.this.reference.getTags().keySet());
            }
            this.keys = new ArrayList(hashSet);
            Collections.sort(this.keys);
            this.fireTableDataChanged();
        }

        protected TagTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
            this.initKeyList();
        }

        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        public Object getValueAt(int n, int n2) {
            return this.keys.get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean hasTag(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getValue(String string) {
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean oppositeHasTag(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return false;
            }
            return historyOsmPrimitive.hasTag(string);
        }

        public String getOppositeValue(String string) {
            PointInTimeType pointInTimeType = this.pointInTimeType.opposite();
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.getPointInTime(pointInTimeType);
            if (historyOsmPrimitive == null) {
                return null;
            }
            return historyOsmPrimitive.get(string);
        }

        public boolean hasSameValueAsOpposite(String string) {
            String string2 = this.getValue(string);
            String string3 = this.getOppositeValue(string);
            if (string2 == null || string3 == null) {
                return false;
            }
            return string2.equals(string3);
        }

        public PointInTimeType getPointInTimeType() {
            return this.pointInTimeType;
        }

        public boolean isCurrentPointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
        }

        public boolean isReferencePointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        public int getColumnCount() {
            return 1;
        }
    }

    public class VersionTableModel
    extends AbstractTableModel {
        private VersionTableModel() {
        }

        public int getRowCount() {
            if (HistoryBrowserModel.this.history == null) {
                return 0;
            }
            int n = HistoryBrowserModel.this.history.getNumVersions();
            if (HistoryBrowserModel.this.latest != null) {
                ++n;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return Long.toString(this.getPrimitive(n).getVersion());
                }
                case 1: {
                    return this.isReferencePointInTime(n);
                }
                case 2: {
                    return this.isCurrentPointInTime(n);
                }
                case 3: {
                    HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive(n);
                    if (historyOsmPrimitive != null && historyOsmPrimitive.getTimestamp() != null) {
                        return DateFormat.getDateTimeInstance(3, 3).format(historyOsmPrimitive.getTimestamp());
                    }
                    return null;
                }
                case 4: {
                    User user;
                    HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive(n);
                    if (historyOsmPrimitive != null && (user = historyOsmPrimitive.getUser()) != null) {
                        return "<html>" + XmlWriter.encode(user.getName(), true) + " <font color=gray>(" + user.getId() + ")</font></html>";
                    }
                    return null;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (!((Boolean)object).booleanValue()) {
                return;
            }
            switch (n2) {
                case 1: {
                    this.setReferencePointInTime(n);
                    break;
                }
                case 2: {
                    this.setCurrentPointInTime(n);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1 && n2 <= 2;
        }

        public void setReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setReferencePointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setReferencePointInTime(historyOsmPrimitive);
        }

        public void setCurrentPointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setCurrentPointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            HistoryBrowserModel.this.setCurrentPointInTime(historyOsmPrimitive);
        }

        public boolean isReferencePointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.reference;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            return historyOsmPrimitive == HistoryBrowserModel.this.reference;
        }

        public boolean isCurrentPointInTime(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (n == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.current;
            }
            if (n < 0 || n > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive historyOsmPrimitive = HistoryBrowserModel.this.history.get(n);
            return historyOsmPrimitive == HistoryBrowserModel.this.current;
        }

        public HistoryOsmPrimitive getPrimitive(int n) {
            if (HistoryBrowserModel.this.history == null) {
                return null;
            }
            return this.isLatest(n) ? HistoryBrowserModel.this.latest : HistoryBrowserModel.this.history.get(n);
        }

        public boolean isLatest(int n) {
            return n >= HistoryBrowserModel.this.history.getNumVersions();
        }

        public OsmPrimitive getLatest() {
            if (HistoryBrowserModel.this.latest == null) {
                return null;
            }
            if (HistoryBrowserModel.this.getEditLayer() == null) {
                return null;
            }
            OsmPrimitive osmPrimitive = HistoryBrowserModel.this.getEditLayer().data.getPrimitiveById(HistoryBrowserModel.this.latest.getId(), HistoryBrowserModel.this.latest.getType());
            return osmPrimitive;
        }

        public int getColumnCount() {
            return 6;
        }
    }
}

