/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.Map_Rectifier_WMSmenuAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryMenu
extends JMenu
implements MapView.LayerChangeListener {
    private Action offsetAction = new JosmAction(I18n.tr("Imagery offset", new Object[0]), "mapmode/adjustimg", I18n.tr("Adjust imagery offset", new Object[0]), null, false, false){
        {
            this.putValue("toolbar", "imagery-offset");
            Main.toolbar.register(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<ImageryLayer> list = Main.map.mapView.getLayersOfType(ImageryLayer.class);
            if (list.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Component component = null;
            if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (list.size() == 1) {
                JComponent jComponent = list.get(0).getOffsetMenuItem(jPopupMenu);
                if (jComponent instanceof JMenuItem) {
                    ((JMenuItem)jComponent).getAction().actionPerformed(actionEvent);
                } else {
                    if (component == null) {
                        return;
                    }
                    jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
                }
                return;
            }
            if (component == null) {
                return;
            }
            for (ImageryLayer imageryLayer : list) {
                JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
                jMenuItem.setText(imageryLayer.getName());
                jMenuItem.setIcon(imageryLayer.getIcon());
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
        }
    };
    private JMenuItem singleOffset;
    private JMenuItem offsetMenuItem = this.singleOffset = new JMenuItem(this.offsetAction);
    private Map_Rectifier_WMSmenuAction rectaction = new Map_Rectifier_WMSmenuAction();
    private int offsPos;

    public ImageryMenu() {
        super(I18n.tr("Imagery", new Object[0]));
        MapView.addLayerChangeListener(this);
    }

    public void refreshImageryMenu() {
        this.removeAll();
        for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getLayers()) {
            this.add(new AddImageryLayerAction(imageryInfo));
        }
        this.addSeparator();
        this.add(new JMenuItem(this.rectaction));
        this.addSeparator();
        this.offsPos = this.getMenuComponentCount();
        this.add(this.offsetMenuItem);
    }

    private JMenuItem getNewOffsetMenu() {
        if (Main.map == null || Main.map.mapView == null) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        List<ImageryLayer> list = Main.map.mapView.getLayersOfType(ImageryLayer.class);
        if (list.isEmpty()) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        this.offsetAction.setEnabled(true);
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset")){

            public MenuElement[] getSubElements() {
                return new MenuElement[0];
            }
        };
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        jMenu.setAction(this.offsetAction);
        if (list.size() == 1) {
            return (JMenuItem)list.get(0).getOffsetMenuItem(jMenu);
        }
        for (ImageryLayer imageryLayer : list) {
            JMenuItem jMenuItem = imageryLayer.getOffsetMenuItem();
            jMenuItem.setText(imageryLayer.getName());
            jMenuItem.setIcon(imageryLayer.getIcon());
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public void refreshOffsetMenu() {
        JMenuItem jMenuItem = this.getNewOffsetMenu();
        this.remove(this.offsetMenuItem);
        this.add((Component)jMenuItem, this.offsPos);
        this.offsetMenuItem = jMenuItem;
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
        if (layer instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }
}

