/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2Util;

public class NTV2SubGrid
implements Cloneable,
Serializable {
    private String subGridName;
    private String parentSubGridName;
    private String created;
    private String updated;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private double latInterval;
    private double lonInterval;
    private int nodeCount;
    private int lonColumnCount;
    private int latRowCount;
    private float[] latShift;
    private float[] lonShift;
    private float[] latAccuracy;
    private float[] lonAccuracy;
    boolean bigEndian;
    private NTV2SubGrid[] subGrid;

    public NTV2SubGrid(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[1];
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.subGridName = new String(byArray).trim();
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.parentSubGridName = new String(byArray).trim();
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.created = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.updated = new String(byArray);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.minLat = NTV2Util.getDouble(byArray, bl);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.maxLat = NTV2Util.getDouble(byArray, bl);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.minLon = NTV2Util.getDouble(byArray, bl);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.maxLon = NTV2Util.getDouble(byArray, bl);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.latInterval = NTV2Util.getDouble(byArray, bl);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.lonInterval = NTV2Util.getDouble(byArray, bl);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        inputStream.read(byArray);
        inputStream.read(byArray);
        this.nodeCount = NTV2Util.getInt(byArray, bl);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
        this.latShift = new float[this.nodeCount];
        this.lonShift = new float[this.nodeCount];
        if (bl2) {
            this.latAccuracy = new float[this.nodeCount];
            this.lonAccuracy = new float[this.nodeCount];
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            inputStream.read(byArray3);
            byArray2[0] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[1] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[2] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[3] = byArray3[0];
            this.latShift[i] = NTV2Util.getFloat(byArray2, bl);
            inputStream.read(byArray3);
            byArray2[0] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[1] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[2] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[3] = byArray3[0];
            this.lonShift[i] = NTV2Util.getFloat(byArray2, bl);
            inputStream.read(byArray3);
            byArray2[0] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[1] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[2] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[3] = byArray3[0];
            if (bl2) {
                this.latAccuracy[i] = NTV2Util.getFloat(byArray2, bl);
            }
            inputStream.read(byArray3);
            byArray2[0] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[1] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[2] = byArray3[0];
            inputStream.read(byArray3);
            byArray2[3] = byArray3[0];
            if (!bl2) continue;
            this.lonAccuracy[i] = NTV2Util.getFloat(byArray2, bl);
        }
    }

    public NTV2SubGrid getSubGridForCoord(double d, double d2) {
        if (this.isCoordWithin(d, d2)) {
            if (this.subGrid == null) {
                return this;
            }
            for (int i = 0; i < this.subGrid.length; ++i) {
                if (!this.subGrid[i].isCoordWithin(d, d2)) continue;
                return this.subGrid[i].getSubGridForCoord(d, d2);
            }
            return this;
        }
        return null;
    }

    private boolean isCoordWithin(double d, double d2) {
        return d >= this.minLon && d < this.maxLon && d2 >= this.minLat && d2 < this.maxLat;
    }

    private final double interpolate(float f, float f2, float f3, float f4, double d, double d2) {
        return (double)f + ((double)f2 - (double)f) * d + ((double)f3 - (double)f) * d2 + ((double)f + (double)f4 - (double)f2 - (double)f3) * d * d2;
    }

    public NTV2GridShift interpolateGridShift(NTV2GridShift nTV2GridShift) {
        int n = (int)((nTV2GridShift.getLonPositiveWestSeconds() - this.minLon) / this.lonInterval);
        int n2 = (int)((nTV2GridShift.getLatSeconds() - this.minLat) / this.latInterval);
        double d = (nTV2GridShift.getLonPositiveWestSeconds() - (this.minLon + this.lonInterval * (double)n)) / this.lonInterval;
        double d2 = (nTV2GridShift.getLatSeconds() - (this.minLat + this.latInterval * (double)n2)) / this.latInterval;
        int n3 = n + n2 * this.lonColumnCount;
        int n4 = n3 + 1;
        int n5 = n3 + this.lonColumnCount;
        int n6 = n5 + 1;
        nTV2GridShift.setLonShiftPositiveWestSeconds(this.interpolate(this.lonShift[n3], this.lonShift[n4], this.lonShift[n5], this.lonShift[n6], d, d2));
        nTV2GridShift.setLatShiftSeconds(this.interpolate(this.latShift[n3], this.latShift[n4], this.latShift[n5], this.latShift[n6], d, d2));
        if (this.lonAccuracy == null) {
            nTV2GridShift.setLonAccuracyAvailable(false);
        } else {
            nTV2GridShift.setLonAccuracyAvailable(true);
            nTV2GridShift.setLonAccuracySeconds(this.interpolate(this.lonAccuracy[n3], this.lonAccuracy[n4], this.lonAccuracy[n5], this.lonAccuracy[n6], d, d2));
        }
        if (this.latAccuracy == null) {
            nTV2GridShift.setLatAccuracyAvailable(false);
        } else {
            nTV2GridShift.setLatAccuracyAvailable(true);
            nTV2GridShift.setLatAccuracySeconds(this.interpolate(this.latAccuracy[n3], this.latAccuracy[n4], this.latAccuracy[n5], this.latAccuracy[n6], d, d2));
        }
        return nTV2GridShift;
    }

    public String getParentSubGridName() {
        return this.parentSubGridName;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSubGridCount() {
        return this.subGrid == null ? 0 : this.subGrid.length;
    }

    public NTV2SubGrid getSubGrid(int n) {
        return this.subGrid == null ? null : this.subGrid[n];
    }

    public void setSubGridArray(NTV2SubGrid[] nTV2SubGridArray) {
        this.subGrid = nTV2SubGridArray;
    }

    public String toString() {
        return this.subGridName;
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer("Sub Grid : ");
        stringBuffer.append(this.subGridName);
        stringBuffer.append("\nParent   : ");
        stringBuffer.append(this.parentSubGridName);
        stringBuffer.append("\nCreated  : ");
        stringBuffer.append(this.created);
        stringBuffer.append("\nUpdated  : ");
        stringBuffer.append(this.updated);
        stringBuffer.append("\nMin Lat  : ");
        stringBuffer.append(this.minLat);
        stringBuffer.append("\nMax Lat  : ");
        stringBuffer.append(this.maxLat);
        stringBuffer.append("\nMin Lon  : ");
        stringBuffer.append(this.minLon);
        stringBuffer.append("\nMax Lon  : ");
        stringBuffer.append(this.maxLon);
        stringBuffer.append("\nLat Intvl: ");
        stringBuffer.append(this.latInterval);
        stringBuffer.append("\nLon Intvl: ");
        stringBuffer.append(this.lonInterval);
        stringBuffer.append("\nNode Cnt : ");
        stringBuffer.append(this.nodeCount);
        return stringBuffer.toString();
    }

    public Object clone() {
        NTV2SubGrid nTV2SubGrid = null;
        try {
            nTV2SubGrid = (NTV2SubGrid)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.subGrid != null) {
            nTV2SubGrid.subGrid = new NTV2SubGrid[this.subGrid.length];
            for (int i = 0; i < this.subGrid.length; ++i) {
                nTV2SubGrid.subGrid[i] = (NTV2SubGrid)this.subGrid[i].clone();
            }
        }
        return nTV2SubGrid;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }
}

