/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About", new Object[0]), "about", I18n.tr("Display the about screen.", new Object[0]), Shortcut.registerShortcut("system:about", I18n.tr("About", new Object[0]), 112, 5005), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        Version version = Version.getInstance();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(Version.loadResourceFile(Main.class.getResource("/README")));
        jTextArea.setCaretPosition(0);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setEditable(false);
        jTextArea2.setText(version.getReleaseAttributes());
        jTextArea2.setCaretPosition(0);
        JTextArea jTextArea3 = new JTextArea();
        jTextArea3.setEditable(false);
        jTextArea3.setText(Version.loadResourceFile(Main.class.getResource("/CONTRIBUTION")));
        jTextArea3.setCaretPosition(0);
        JTextArea jTextArea4 = new JTextArea();
        jTextArea4.setEditable(false);
        jTextArea4.setText(Version.loadResourceFile(Main.class.getResource("/LICENSE")));
        jTextArea4.setCaretPosition(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        jLabel.setFont(new Font("Helvetica", 1, 20));
        jPanel.add((Component)jLabel, GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Version {0}", version.getVersionString())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Last change at {0}", version.getTime())), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Java Version {0}", System.getProperty("java.version"))), GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add(GBC.glue(0, 10), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Homepage", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de", 2), GBC.eol().fill(2));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Bug Reports", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket", 2), GBC.eol().fill(2));
        jTabbedPane.addTab(I18n.tr("Info", new Object[0]), jPanel);
        jTabbedPane.addTab(I18n.tr("Readme", new Object[0]), this.createScrollPane(jTextArea));
        jTabbedPane.addTab(I18n.tr("Revision", new Object[0]), this.createScrollPane(jTextArea2));
        jTabbedPane.addTab(I18n.tr("Contribution", new Object[0]), this.createScrollPane(jTextArea3));
        jTabbedPane.addTab(I18n.tr("License", new Object[0]), this.createScrollPane(jTextArea4));
        jTabbedPane.addTab(I18n.tr("Plugins", new Object[0]), new JScrollPane(PluginHandler.getInfoPanel()));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setPreferredSize(new Dimension(600, 300));
        jPanel2.add((Component)jTabbedPane, GBC.std().fill());
        GuiHelper.prepareResizeableOptionPane(jPanel2, jPanel2.getPreferredSize());
        JOptionPane.showMessageDialog(Main.parent, jPanel2, I18n.tr("About JOSM...", new Object[0]), 1, ImageProvider.get("logo"));
    }

    private JScrollPane createScrollPane(JTextArea jTextArea) {
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }
}

