/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ImageryHandler
extends RequestHandler {
    public static final String command = "imagery";

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load an imagery layer from the following URL:", new Object[0]) + "<br>" + (String)this.args.get("url");
    }

    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_IMAGERY;
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        String string;
        if (Main.map == null) {
            throw new RequestHandler.RequestHandlerErrorException();
        }
        String string2 = (String)this.args.get("url");
        String string3 = (String)this.args.get("title");
        String string4 = (String)this.args.get("type");
        if (string3 == null || string3.isEmpty()) {
            string3 = I18n.tr("Remote imagery", new Object[0]);
        }
        String string5 = (String)this.args.get("cookies");
        ImageryInfo imageryInfo = new ImageryInfo(string3, string2, string4, null, string5);
        String string6 = (String)this.args.get("min_zoom");
        if (string6 != null && !string6.isEmpty()) {
            try {
                imageryInfo.setDefaultMinZoom(Integer.parseInt(string6));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        if ((string = (String)this.args.get("max_zoom")) != null && !string.isEmpty()) {
            try {
                imageryInfo.setDefaultMaxZoom(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
        }
        Main.main.addLayer(ImageryLayer.create(imageryInfo));
    }

    protected void parseArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.request.indexOf(63) != -1) {
            String string = this.request.substring(this.request.indexOf(63) + 1);
            if (string.indexOf("url=") == 0) {
                hashMap.put("url", this.decodeParam(string.substring(4)));
            } else {
                String[] stringArray;
                int n = string.indexOf("&url=");
                if (n != -1) {
                    hashMap.put("url", this.decodeParam(string.substring(n + 5)));
                    string = string.substring(0, n);
                } else if (string.indexOf(35) != -1) {
                    string = string.substring(0, string.indexOf(35));
                }
                for (String string2 : stringArray = string.split("&", -1)) {
                    int n2 = string2.indexOf(61);
                    if (n2 == -1) continue;
                    hashMap.put(string2.substring(0, n2), this.decodeParam(string2.substring(n2 + 1)));
                }
            }
        }
        this.args = hashMap;
    }

    private String decodeParam(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException();
        }
    }
}

