/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxWriter
extends XmlWriter {
    private GpxData data;
    private String indent = "";
    private static final int WAY_POINT = 0;
    private static final int ROUTE_POINT = 1;
    private static final int TRACK_POINT = 2;
    public static List<String> WPT_KEYS = Arrays.asList("ele", "time", "magvar", "geoidheight", "name", "cmt", "desc", "src", "meta.links", "sym", "number", "type", "fix", "sat", "hdop", "vdop", "pdop", "ageofdgpsdata", "dgpsid");

    public GpxWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    public GpxWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"))));
    }

    public GpxWriter() {
        super(null);
    }

    public void write(GpxData gpxData) {
        this.data = gpxData;
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<gpx version=\"1.1\" creator=\"JOSM GPX export\" xmlns=\"http://www.topografix.com/GPX/1/1\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
        this.indent = "  ";
        this.writeMetaData();
        this.writeWayPoints();
        this.writeRoutes();
        this.writeTracks();
        this.out.print("</gpx>");
        this.out.flush();
    }

    private void writeAttr(Map<String, Object> map) {
        for (String string : WPT_KEYS) {
            Object object = map.get(string);
            if (object == null) continue;
            if (string.equals("meta.links")) {
                for (GpxLink gpxLink : (Collection)object) {
                    this.gpxLink(gpxLink);
                }
                continue;
            }
            this.simpleTag(string, object.toString());
        }
    }

    private void writeMetaData() {
        Object object;
        Object object2;
        Map map = this.data.attr;
        this.openln("metadata");
        if (map.containsKey("meta.desc")) {
            this.simpleTag("desc", (String)map.get("meta.desc"));
        }
        if (map.containsKey("meta.author.name") || map.containsKey("meta.author.email")) {
            this.openln("author");
            this.simpleTag("name", (String)map.get("meta.author.name"));
            if (map.containsKey("meta.author.email") && ((String[])(object2 = ((String)map.get("meta.author.email")).split("@"))).length == 2) {
                this.inline("email", "id=\"" + (String)object2[0] + "\" domain=\"" + (String)object2[1] + "\"");
            }
            this.gpxLink((GpxLink)map.get("meta.author.link"));
            this.closeln("author");
        }
        if (map.containsKey("meta.copyright.license") || map.containsKey("meta.copyright.year")) {
            this.openAtt("copyright", "author=\"" + map.get("meta.copyright.author") + "\"");
            if (map.containsKey("meta.copyright.year")) {
                this.simpleTag("year", (String)map.get("meta.copyright.year"));
            }
            if (map.containsKey("meta.copyright.license")) {
                this.simpleTag("license", GpxWriter.encode((String)map.get("meta.copyright.license")));
            }
            this.closeln("copyright");
        }
        if (map.containsKey("meta.links")) {
            object2 = ((Collection)map.get("meta.links")).iterator();
            while (object2.hasNext()) {
                object = (GpxLink)object2.next();
                this.gpxLink((GpxLink)object);
            }
        }
        if (map.containsKey("meta.keywords")) {
            this.simpleTag("keywords", (String)map.get("meta.keywords"));
        }
        if ((object2 = this.data.recalculateBounds()) != null) {
            object = "minlat=\"" + ((Bounds)object2).getMin().lat() + "\" minlon=\"" + ((Bounds)object2).getMin().lon() + "\" maxlat=\"" + ((Bounds)object2).getMax().lat() + "\" maxlon=\"" + ((Bounds)object2).getMax().lon() + "\"";
            this.inline("bounds", (String)object);
        }
        this.closeln("metadata");
    }

    private void writeWayPoints() {
        for (WayPoint wayPoint : this.data.waypoints) {
            this.wayPoint(wayPoint, 0);
        }
    }

    private void writeRoutes() {
        for (GpxRoute gpxRoute : this.data.routes) {
            this.openln("rte");
            this.writeAttr(gpxRoute.attr);
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                this.wayPoint(wayPoint, 1);
            }
            this.closeln("rte");
        }
    }

    private void writeTracks() {
        for (GpxTrack gpxTrack : this.data.tracks) {
            this.openln("trk");
            this.writeAttr(gpxTrack.getAttributes());
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                this.openln("trkseg");
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    this.wayPoint(wayPoint, 2);
                }
                this.closeln("trkseg");
            }
            this.closeln("trk");
        }
    }

    private void openln(String string) {
        this.open(string);
        this.out.println();
    }

    private void open(String string) {
        this.out.print(this.indent + "<" + string + ">");
        this.indent = this.indent + "  ";
    }

    private void openAtt(String string, String string2) {
        this.out.println(this.indent + "<" + string + " " + string2 + ">");
        this.indent = this.indent + "  ";
    }

    private void inline(String string, String string2) {
        this.out.println(this.indent + "<" + string + " " + string2 + "/>");
    }

    private void close(String string) {
        this.indent = this.indent.substring(2);
        this.out.print(this.indent + "</" + string + ">");
    }

    private void closeln(String string) {
        this.close(string);
        this.out.println();
    }

    private void simpleTag(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            this.open(string);
            this.out.print(GpxWriter.encode(string2));
            this.out.println("</" + string + ">");
            this.indent = this.indent.substring(2);
        }
    }

    private void gpxLink(GpxLink gpxLink) {
        if (gpxLink != null) {
            this.openAtt("link", "href=\"" + gpxLink.uri + "\"");
            this.simpleTag("text", gpxLink.text);
            this.simpleTag("type", gpxLink.type);
            this.closeln("link");
        }
    }

    private void wayPoint(WayPoint wayPoint, int n) {
        String string;
        switch (n) {
            case 0: {
                string = "wpt";
                break;
            }
            case 1: {
                string = "rtept";
                break;
            }
            case 2: {
                string = "trkpt";
                break;
            }
            default: {
                throw new RuntimeException(I18n.tr("Unknown mode {0}.", n));
            }
        }
        if (wayPoint != null) {
            LatLon latLon = wayPoint.getCoor();
            String string2 = "lat=\"" + latLon.lat() + "\" lon=\"" + latLon.lon() + "\"";
            if (wayPoint.attr.isEmpty()) {
                this.inline(string, string2);
            } else {
                this.openAtt(string, string2);
                this.writeAttr(wayPoint.attr);
                this.closeln(string);
            }
        }
    }
}

