/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LafPreference
implements SubPreferenceSetting {
    private JosmComboBox lafCombo;
    public JPanel panel;
    private JCheckBox showSplashScreen = new JCheckBox(I18n.tr("Show splash screen at startup", new Object[0]));
    private JCheckBox showID = new JCheckBox(I18n.tr("Show object ID in selection lists", new Object[0]));
    private JCheckBox showLocalizedName = new JCheckBox(I18n.tr("Show localized name in selection lists", new Object[0]));
    private JCheckBox modeless = new JCheckBox(I18n.tr("Modeless working (Potlatch style)", new Object[0]));
    private JCheckBox dynamicButtons = new JCheckBox(I18n.tr("Dynamic buttons in side menus", new Object[0]));

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        Object object;
        this.lafCombo = new JosmComboBox(UIManager.getInstalledLookAndFeels());
        try {
            object = Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            Object obj = ((Class)object).getConstructor(null).newInstance(null);
            this.lafCombo.addItem(new UIManager.LookAndFeelInfo(((LookAndFeel)obj).getName(), "ch.randelshofer.quaqua.QuaquaLookAndFeel"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = Main.pref.get("laf", Main.platform.getDefaultStyle());
        for (int i = 0; i < this.lafCombo.getItemCount(); ++i) {
            if (!((UIManager.LookAndFeelInfo)this.lafCombo.getItemAt(i)).getClassName().equals(object)) continue;
            this.lafCombo.setSelectedIndex(i);
            break;
        }
        final ListCellRenderer listCellRenderer = this.lafCombo.getRenderer();
        this.lafCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, ((UIManager.LookAndFeelInfo)object).getName(), n, bl, bl2);
            }
        });
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showSplashScreen.setToolTipText(I18n.tr("Show splash screen at startup", new Object[0]));
        this.showSplashScreen.setSelected(Main.pref.getBoolean("draw.splashscreen", true));
        this.panel.add((Component)this.showSplashScreen, GBC.eop().insets(20, 0, 0, 0));
        this.showID.setToolTipText(I18n.tr("Show object ID in selection lists", new Object[0]));
        this.showID.setSelected(Main.pref.getBoolean("osm-primitives.showid", false));
        this.showLocalizedName.setToolTipText(I18n.tr("Show localized name in selection lists, if available", new Object[0]));
        this.showLocalizedName.setSelected(Main.pref.getBoolean("osm-primitives.localize-name", true));
        ExpertToggleAction.addVisibilitySwitcher(this.showLocalizedName);
        this.modeless.setToolTipText(I18n.tr("Do not require to switch modes (potlatch style workflow)", new Object[0]));
        this.modeless.setSelected(Main.pref.getBoolean("modeless", false));
        ExpertToggleAction.addVisibilitySwitcher(this.modeless);
        this.panel.add((Component)this.showID, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.showLocalizedName, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add((Component)this.modeless, GBC.eop().insets(20, 0, 0, 0));
        this.dynamicButtons.setToolTipText(I18n.tr("Display buttons in right side menus only when mouse is inside the element", new Object[0]));
        this.dynamicButtons.setSelected(Main.pref.getBoolean("dialog.dynamic.buttons", true));
        this.panel.add((Component)this.dynamicButtons, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.panel.add((Component)new JLabel(I18n.tr("Look and Feel", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add((Component)this.lafCombo, GBC.eol().fill(2));
        JScrollPane jScrollPane = new JScrollPane(this.panel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        preferenceTabbedPane.getDisplayPreference().displaycontent.addTab(I18n.tr("Look and Feel", new Object[0]), jScrollPane);
    }

    public boolean ok() {
        boolean bl = false;
        Main.pref.put("draw.splashscreen", this.showSplashScreen.isSelected());
        Main.pref.put("osm-primitives.showid", this.showID.isSelected());
        Main.pref.put("osm-primitives.localize-name", this.showLocalizedName.isSelected());
        Main.pref.put("modeless", this.modeless.isSelected());
        Main.pref.put("dialog.dynamic.buttons", this.dynamicButtons.isSelected());
        return bl |= Main.pref.put("laf", ((UIManager.LookAndFeelInfo)this.lafCombo.getSelectedItem()).getClassName());
    }

    public boolean isExpert() {
        return false;
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getDisplayPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new LafPreference();
        }
    }
}

