/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener,
ExpertToggleAction.ExpertModeChangeListener,
ChangeListener {
    private final List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> settingsFactory = new LinkedList<PreferenceSettingFactory>();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting) {
        return this.createPreferenceTab(tabPreferenceSetting, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting tabPreferenceSetting, boolean bl) {
        PreferencePanel preferencePanel;
        CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting);
        JComponent jComponent = preferencePanel = new PreferencePanel(tabPreferenceSetting);
        if (bl) {
            PreferenceScrollPane preferenceScrollPane = new PreferenceScrollPane(preferencePanel);
            jComponent = preferenceScrollPane;
        }
        this.tabs.add((PreferenceTab)((Object)jComponent));
        return preferencePanel;
    }

    private void selectTabBy(TabIdentifier tabIdentifier, Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            PreferenceTab preferenceTab;
            Component component = this.getComponentAt(i);
            if (!(component instanceof PreferenceTab) || !tabIdentifier.identify((preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting(), object)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void selectTabByName(String string) {
        this.selectTabBy(new TabIdentifier(){

            public boolean identify(TabPreferenceSetting tabPreferenceSetting, Object object) {
                return tabPreferenceSetting.getIconName().equals(object);
            }
        }, string);
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy(new TabIdentifier(){

            public boolean identify(TabPreferenceSetting tabPreferenceSetting, Object object) {
                return tabPreferenceSetting.getClass().isAssignableFrom((Class)object);
            }
        }, clazz);
    }

    public final DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public final MapPreference getMapPreference() {
        return this.getSetting(MapPreference.class);
    }

    public final PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public final ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public void savePreferences() {
        if (Main.applet) {
            return;
        }
        PluginPreference pluginPreference = this.getPluginPreference();
        List<PluginInformation> list = pluginPreference.getPluginsScheduledForUpdateOrDownload();
        final PluginDownloadTask pluginDownloadTask = list != null && !list.isEmpty() ? new PluginDownloadTask((Component)this, list, I18n.tr("Download plugins", new Object[0])) : null;
        final Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() && !pluginDownloadTask.getDownloadedPlugins().isEmpty()) {
                    bl = true;
                }
                for (PreferenceSetting preferenceSetting : PreferenceTabbedPane.this.settingsInitialized) {
                    if (!preferenceSetting.ok()) continue;
                    bl = true;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled()) {
                    stringBuilder.append(PluginPreference.buildDownloadSummary(pluginDownloadTask));
                }
                if (bl) {
                    stringBuilder.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                }
                stringBuilder.append("</html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() || bl) {
                    JOptionPane.showMessageDialog(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
                }
                Main.parent.repaint();
            }
        };
        if (pluginDownloadTask != null) {
            Main.worker.submit(pluginDownloadTask);
            Main.worker.submit(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(runnable);
                }
            });
        } else {
            runnable.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
        super.getModel().addChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        for (PreferenceSettingFactory preferenceSettingFactory : settingsFactory) {
            PreferenceSetting preferenceSetting = preferenceSettingFactory.createPreferenceSetting();
            if (preferenceSetting == null) continue;
            this.settings.add(preferenceSetting);
        }
        this.addGUITabs(false);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting) {
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertGUITabsForSetting(icon, tabPreferenceSetting, this.getTabCount());
        }
    }

    private void insertGUITabsForSetting(Icon icon, TabPreferenceSetting tabPreferenceSetting, int n) {
        int n2 = n;
        for (PreferenceTab preferenceTab : this.tabs) {
            if (!preferenceTab.getTabPreferenceSetting().equals(tabPreferenceSetting)) continue;
            this.insertTab(null, icon, preferenceTab.getComponent(), tabPreferenceSetting.getTooltip(), n2++);
        }
    }

    private void addGUITabs(boolean bl) {
        boolean bl2 = ExpertToggleAction.isExpert();
        Component component = this.getSelectedComponent();
        if (bl) {
            this.removeAll();
        }
        for (PreferenceSetting preferenceSetting : this.settings) {
            ImageIcon imageIcon;
            if (!(preferenceSetting instanceof TabPreferenceSetting)) continue;
            TabPreferenceSetting tabPreferenceSetting = (TabPreferenceSetting)preferenceSetting;
            if (!bl2 && tabPreferenceSetting.isExpert()) continue;
            String string = tabPreferenceSetting.getIconName();
            ImageIcon imageIcon2 = imageIcon = string != null && string.length() > 0 ? ImageProvider.get("preferences", string) : null;
            if (imageIcon != null && (imageIcon.getIconHeight() != 48 || imageIcon.getIconWidth() != 48)) {
                imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(48, 48, 1));
            }
            if (this.settingsInitialized.contains(tabPreferenceSetting)) {
                this.addGUITabsForSetting(imageIcon, tabPreferenceSetting);
                continue;
            }
            this.addTab(null, imageIcon, new PreferencePanel(tabPreferenceSetting), tabPreferenceSetting.getTooltip());
        }
        try {
            if (component != null) {
                this.setSelectedComponent(component);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void expertChanged(boolean bl) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (super.indexAtLocation(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y) < 0) {
            return;
        }
        int n = super.getSelectedIndex() + mouseWheelEvent.getWheelRotation();
        n = n < 0 ? 0 : n;
        n = n >= super.getTabCount() ? super.getTabCount() - 1 : n;
        super.setSelectedIndex(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        PreferenceTab preferenceTab;
        TabPreferenceSetting tabPreferenceSetting;
        int n = this.getSelectedIndex();
        Component component = this.getSelectedComponent();
        if (n > -1 && component instanceof PreferenceTab && !this.settingsInitialized.contains(tabPreferenceSetting = (preferenceTab = (PreferenceTab)((Object)component)).getTabPreferenceSetting())) {
            try {
                this.getModel().removeChangeListener(this);
                tabPreferenceSetting.addGui(this);
                for (PreferenceSetting preferenceSetting : this.settings) {
                    SubPreferenceSetting subPreferenceSetting;
                    if (!(preferenceSetting instanceof SubPreferenceSetting) || (subPreferenceSetting = (SubPreferenceSetting)preferenceSetting).getTabPreferenceSetting(this) != tabPreferenceSetting) continue;
                    try {
                        subPreferenceSetting.addGui(this);
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        BugReportExceptionHandler.handleException(throwable);
                    }
                    finally {
                        this.settingsInitialized.add(subPreferenceSetting);
                    }
                }
                Icon icon = this.getIconAt(n);
                this.remove(n);
                this.insertGUITabsForSetting(icon, tabPreferenceSetting, n);
                this.setSelectedIndex(n);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (Throwable throwable) {
                BugReportExceptionHandler.handleException(throwable);
            }
            finally {
                this.settingsInitialized.add(tabPreferenceSetting);
                this.getModel().addChangeListener(this);
            }
        }
    }

    static {
        settingsFactory.add(new DisplayPreference.Factory());
        settingsFactory.add(new DrawingPreference.Factory());
        settingsFactory.add(new ColorPreference.Factory());
        settingsFactory.add(new LafPreference.Factory());
        settingsFactory.add(new LanguagePreference.Factory());
        settingsFactory.add(new ServerAccessPreference.Factory());
        settingsFactory.add(new MapPreference.Factory());
        settingsFactory.add(new ProjectionPreference.Factory());
        settingsFactory.add(new MapPaintPreference.Factory());
        settingsFactory.add(new TaggingPresetPreference.Factory());
        settingsFactory.add(new BackupPreference.Factory());
        if (!Main.applet) {
            settingsFactory.add(new PluginPreference.Factory());
        }
        settingsFactory.add(Main.toolbar);
        settingsFactory.add(new AudioPreference.Factory());
        settingsFactory.add(new ShortcutPreference.Factory());
        settingsFactory.add(new ValidatorPreference.Factory());
        settingsFactory.add(new RemoteControlPreference.Factory());
        settingsFactory.add(new ImageryPreference.Factory());
        PluginHandler.getPreferenceSetting(settingsFactory);
        settingsFactory.add(new AdvancedPreference.Factory());
    }

    private static interface TabIdentifier {
        public boolean identify(TabPreferenceSetting var1, Object var2);
    }

    public static class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(Component component, TabPreferenceSetting tabPreferenceSetting) {
            super(component);
            this.preferenceSetting = tabPreferenceSetting;
        }

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            super(preferencePanel.getComponent());
            this.preferenceSetting = preferencePanel.getTabPreferenceSetting();
        }

        public final TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        public Component getComponent() {
            return this;
        }
    }

    public static class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting tabPreferenceSetting) {
            super(new GridBagLayout());
            CheckParameterUtil.ensureParameterNotNull(tabPreferenceSetting);
            this.preferenceSetting = tabPreferenceSetting;
            this.buildPanel();
        }

        protected void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)new JLabel(this.preferenceSetting.getTitle()), GBC.eol().insets(0, 5, 0, 10).anchor(18));
            JLabel jLabel = new JLabel("<html>" + this.preferenceSetting.getDescription() + "</html>");
            jLabel.setFont(jLabel.getFont().deriveFont(2));
            this.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        }

        public final TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }
}

