/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cascade
implements Cloneable {
    public static final Cascade EMPTY_CASCADE = new Cascade();
    protected Map<String, Object> prop = new HashMap<String, Object>();

    public <T> T get(String string, T t, Class<T> clazz) {
        return this.get(string, t, clazz, false);
    }

    public <T> T get(String string, T t, Class<T> clazz, boolean bl) {
        if (t != null && !clazz.isInstance(t)) {
            throw new IllegalArgumentException();
        }
        Object object = this.prop.get(string);
        if (object == null) {
            return t;
        }
        T t2 = Cascade.convertTo(object, clazz);
        if (t2 == null) {
            if (!bl) {
                System.err.println(String.format("Warning: unable to convert property %s to type %s: found %s of type %s!", string, clazz, object, object.getClass()));
            }
            return t;
        }
        return t2;
    }

    public Object get(String string) {
        return this.prop.get(string);
    }

    public void put(String string, Object object) {
        this.prop.put(string, object);
    }

    public void putOrClear(String string, Object object) {
        if (object != null) {
            this.prop.put(string, object);
        } else {
            this.prop.remove(string);
        }
    }

    public void remove(String string) {
        this.prop.remove(string);
    }

    public static <T> T convertTo(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)Cascade.toFloat(object);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if ((object = Cascade.toFloat(object)) != null) {
                object = new Double(((Float)object).floatValue());
            }
            return (T)object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Cascade.toBool(object);
        }
        if (clazz == float[].class) {
            return (T)Cascade.toFloatArray(object);
        }
        if (clazz == Color.class) {
            return (T)Cascade.toColor(object);
        }
        if (clazz == String.class) {
            if (object instanceof Keyword) {
                return (T)((Keyword)object).val;
            }
            return (T)object.toString();
        }
        return null;
    }

    private static Float toFloat(Object object) {
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Double) {
            return new Float((Double)object);
        }
        if (object instanceof Integer) {
            return new Float(((Integer)object).intValue());
        }
        if (object instanceof String) {
            try {
                float f = Float.parseFloat((String)object);
                return Float.valueOf(f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Boolean toBool(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Keyword) {
            String string = ((Keyword)object).val;
            if (Utils.equal(string, "true") || Utils.equal(string, "yes")) {
                return true;
            }
            if (Utils.equal(string, "false") || Utils.equal(string, "no")) {
                return false;
            }
        }
        return null;
    }

    private static float[] toFloatArray(Object object) {
        if (object instanceof float[]) {
            return (float[])object;
        }
        if (object instanceof List) {
            List list = (List)object;
            float[] fArray = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Float f = Cascade.toFloat(list.get(i));
                if (f == null) {
                    return null;
                }
                fArray[i] = f.floatValue();
            }
            return fArray;
        }
        Float f = Cascade.toFloat(object);
        if (f != null) {
            return new float[]{f.floatValue()};
        }
        return null;
    }

    private static Color toColor(Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof Keyword) {
            return CSSColors.get(((Keyword)object).val);
        }
        return null;
    }

    public Cascade clone() {
        HashMap hashMap = (HashMap)((HashMap)this.prop).clone();
        Cascade cascade = new Cascade();
        cascade.prop = hashMap;
        return cascade;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Cascade{ ");
        for (String string : this.prop.keySet()) {
            stringBuilder.append(string + ":");
            Object object = this.prop.get(string);
            if (object instanceof float[]) {
                stringBuilder.append(Arrays.toString((float[])object));
            } else if (object instanceof Color) {
                stringBuilder.append(Utils.toString((Color)object));
            } else {
                stringBuilder.append(object + "");
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.append("}").toString();
    }

    public boolean containsKey(String string) {
        return this.prop.containsKey(string);
    }
}

