/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.CachedProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
implements TemplateEngineDataProvider {
    public static final List<MarkerProducers> markerProducers = new LinkedList<MarkerProducers>();
    public static final String MARKER_OFFSET = "waypointOffset";
    public static final String MARKER_FORMATTED_OFFSET = "formattedWaypointOffset";
    public static final String LABEL_PATTERN_AUTO = "?{ '{name} - {desc}' | '{name}' | '{desc}' }";
    public static final String LABEL_PATTERN_NAME = "{name}";
    public static final String LABEL_PATTERN_DESC = "{desc}";
    private final TemplateEngineDataProvider dataProvider;
    private final String text;
    public final Icon symbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private String cachedText;
    private int textVersion = -1;
    private CachedLatLon coor;

    public static Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
        for (MarkerProducers markerProducers : Marker.markerProducers) {
            Marker marker = markerProducers.createMarker(wayPoint, file, markerLayer, d, d2);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public Marker(LatLon latLon, TemplateEngineDataProvider templateEngineDataProvider, String string, MarkerLayer markerLayer, double d, double d2) {
        this.setCoor(latLon);
        this.offset = d2;
        this.time = d;
        this.symbol = string != null ? ImageProvider.getIfAvailable("markers", string) : null;
        this.parentLayer = markerLayer;
        this.dataProvider = templateEngineDataProvider;
        this.text = null;
    }

    public Marker(LatLon latLon, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        this.setCoor(latLon);
        this.offset = d2;
        this.time = d;
        this.symbol = string2 != null ? ImageProvider.getIfAvailable("markers", string2) : null;
        this.parentLayer = markerLayer;
        this.dataProvider = null;
        this.text = string;
    }

    public final void setCoor(LatLon latLon) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(latLon);
        } else {
            this.coor.setCoor(latLon);
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor.setEastNorth(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public boolean containsPoint(Point point) {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void paint(Graphics graphics, MapView mapView, boolean bl, boolean bl2) {
        Point point = mapView.getPoint(this.getEastNorth());
        if (this.symbol != null && bl2) {
            this.symbol.paintIcon(mapView, graphics, point.x - this.symbol.getIconWidth() / 2, point.y - this.symbol.getIconHeight() / 2);
        } else {
            graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
            graphics.drawLine(point.x + 2, point.y - 2, point.x - 2, point.y + 2);
        }
        String string = this.getText();
        if (string != null && bl2) {
            graphics.drawString(string, point.x + 4, point.y + 2);
        }
    }

    protected TemplateEntryProperty getTextTemplate() {
        return TemplateEntryProperty.forMarker(this.parentLayer.getName());
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        TemplateEntryProperty templateEntryProperty = this.getTextTemplate();
        if (templateEntryProperty.getUpdateCount() != this.textVersion) {
            TemplateEntry templateEntry = (TemplateEntry)templateEntryProperty.get();
            StringBuilder stringBuilder = new StringBuilder();
            templateEntry.appendText(stringBuilder, this);
            this.cachedText = stringBuilder.toString();
            this.textVersion = templateEntryProperty.getUpdateCount();
        }
        return this.cachedText;
    }

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> collection = this.dataProvider != null ? this.dataProvider.getTemplateKeys() : new ArrayList<String>();
        collection.add(MARKER_FORMATTED_OFFSET);
        collection.add(MARKER_OFFSET);
        return collection;
    }

    private String formatOffset() {
        int n = (int)(this.offset + 0.5);
        if (n < 60) {
            return Integer.toString(n);
        }
        if (n < 3600) {
            return String.format("%d:%02d", n / 60, n % 60);
        }
        return String.format("%d:%02d:%02d", n / 3600, n % 3600 / 60, n % 60);
    }

    @Override
    public Object getTemplateValue(String string, boolean bl) {
        if (MARKER_FORMATTED_OFFSET.equals(string)) {
            return this.formatOffset();
        }
        if (MARKER_OFFSET.equals(string)) {
            return this.offset;
        }
        if (this.dataProvider != null) {
            return this.dataProvider.getTemplateValue(string, bl);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match match) {
        throw new UnsupportedOperationException();
    }

    static {
        markerProducers.add(new MarkerProducers(){

            public Marker createMarker(WayPoint wayPoint, File file, MarkerLayer markerLayer, double d, double d2) {
                Object object;
                Object object2;
                block10: {
                    String string = null;
                    Collection collection = (Collection)wayPoint.attr.get("meta.links");
                    if (collection != null && (object2 = collection.iterator()).hasNext()) {
                        object = (GpxLink)object2.next();
                        string = ((GpxLink)object).uri;
                    }
                    object2 = null;
                    if (string != null) {
                        try {
                            object2 = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            if (file == null) break block10;
                            try {
                                object2 = new File(file.getParentFile(), string).toURI().toURL();
                            }
                            catch (MalformedURLException malformedURLException2) {
                                Main.warn("Unable to convert uri {0} to URL: {1}", string, malformedURLException2.getMessage());
                            }
                        }
                    }
                }
                if (object2 == null) {
                    object = wayPoint.getString("symbol");
                    if (object == null) {
                        object = wayPoint.getString("sym");
                    }
                    return new Marker(wayPoint.getCoor(), wayPoint, (String)object, markerLayer, d, d2);
                }
                if (((URL)object2).toString().endsWith(".wav")) {
                    return new AudioMarker(wayPoint.getCoor(), (TemplateEngineDataProvider)wayPoint, (URL)object2, markerLayer, d, d2);
                }
                if (((URL)object2).toString().endsWith(".png") || ((URL)object2).toString().endsWith(".jpg") || ((URL)object2).toString().endsWith(".jpeg") || ((URL)object2).toString().endsWith(".gif")) {
                    return new ImageMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2);
                }
                return new WebMarker(wayPoint.getCoor(), (URL)object2, markerLayer, d, d2);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateEntryProperty
    extends CachedProperty<TemplateEntry> {
        private static final Map<String, TemplateEntryProperty> cache = new HashMap<String, TemplateEntryProperty>();
        private static final IntegerProperty PROP_LABEL = new IntegerProperty("draw.rawgps.layer.wpt", 0);
        private TemplateEntryProperty parent;

        private static String getDefaultLabelPattern() {
            switch (PROP_LABEL.get()) {
                case 1: {
                    return Marker.LABEL_PATTERN_NAME;
                }
                case 2: {
                    return Marker.LABEL_PATTERN_DESC;
                }
                case 0: 
                case 3: {
                    return Marker.LABEL_PATTERN_AUTO;
                }
            }
            return "";
        }

        public static TemplateEntryProperty forMarker(String string) {
            TemplateEntryProperty templateEntryProperty;
            String string2 = "draw.rawgps.layer.wpt.pattern";
            if (string != null) {
                string2 = string2 + "." + string;
            }
            if ((templateEntryProperty = cache.get(string2)) == null) {
                String string3 = string == null ? TemplateEntryProperty.getDefaultLabelPattern() : "";
                TemplateEntryProperty templateEntryProperty2 = string == null ? null : TemplateEntryProperty.forMarker(null);
                try {
                    templateEntryProperty = new TemplateEntryProperty(string2, string3, templateEntryProperty2);
                    cache.put(string2, templateEntryProperty);
                }
                catch (ParseError parseError) {
                    Main.warn("Unable to parse template engine pattern ''{0}'' for property {1}", string3, string2);
                }
            }
            return templateEntryProperty;
        }

        public static TemplateEntryProperty forAudioMarker(String string) {
            TemplateEntryProperty templateEntryProperty;
            String string2 = "draw.rawgps.layer.audiowpt.pattern";
            if (string != null) {
                string2 = string2 + "." + string;
            }
            if ((templateEntryProperty = cache.get(string2)) == null) {
                String string3 = string == null ? "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }" : "";
                TemplateEntryProperty templateEntryProperty2 = string == null ? null : TemplateEntryProperty.forAudioMarker(null);
                try {
                    templateEntryProperty = new TemplateEntryProperty(string2, string3, templateEntryProperty2);
                    cache.put(string2, templateEntryProperty);
                }
                catch (ParseError parseError) {
                    Main.warn("Unable to parse template engine pattern ''{0}'' for property {1}", string3, string2);
                }
            }
            return templateEntryProperty;
        }

        private TemplateEntryProperty(String string, String string2, TemplateEntryProperty templateEntryProperty) throws ParseError {
            super(string, string2);
            this.parent = templateEntryProperty;
            this.updateValue();
        }

        @Override
        protected TemplateEntry fromString(String string) {
            try {
                return new TemplateParser(string).parse();
            }
            catch (ParseError parseError) {
                Main.warn("Unable to parse template engine pattern ''{0}'' for property {1}. Using default (''{2}'') instead", string, this.getKey(), super.getDefaultValueAsString());
                return (TemplateEntry)this.getDefaultValue();
            }
        }

        @Override
        public String getDefaultValueAsString() {
            if (this.parent == null) {
                return super.getDefaultValueAsString();
            }
            return this.parent.getAsString();
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey().equals(this.key) || this.parent != null && preferenceChangeEvent.getKey().equals(this.parent.getKey())) {
                this.updateValue();
            }
        }
    }
}

