/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Point;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;

class ImproveWayAccuracyHelper {
    ImproveWayAccuracyHelper() {
    }

    public static Way findWay(MapView mapView, Point point) {
        if (mapView == null || point == null) {
            return null;
        }
        Node node = mapView.getNearestNode(point, OsmPrimitive.isSelectablePredicate);
        Way way = null;
        if (node != null) {
            List<OsmPrimitive> list = node.getReferrers();
            for (OsmPrimitive osmPrimitive : list) {
                if (!(osmPrimitive instanceof Way)) continue;
                way = (Way)osmPrimitive;
                break;
            }
            if (way != null) {
                return way;
            }
        }
        way = Main.map.mapView.getNearestWay(point, OsmPrimitive.isSelectablePredicate);
        return way;
    }

    public static Node findCandidateNode(MapView mapView, Way way, Point point) {
        if (mapView == null || way == null || point == null) {
            return null;
        }
        EastNorth eastNorth = mapView.getEastNorth(point.x, point.y);
        Double d = Double.MAX_VALUE;
        List<Pair<Node, Node>> list = way.getNodePairs(false);
        Node node = null;
        block0: for (Node node2 : way.getNodes()) {
            EastNorth eastNorth2 = node2.getEastNorth();
            Double d2 = eastNorth.distance(eastNorth2);
            if (!(d2 < d)) continue;
            for (Pair<Node, Node> pair : list) {
                if (((Node)pair.a).equals(node2) || ((Node)pair.b).equals(node2) || Geometry.getSegmentSegmentIntersection(((Node)pair.a).getEastNorth(), ((Node)pair.b).getEastNorth(), eastNorth, eastNorth2) == null) continue;
                continue block0;
            }
            node = node2;
            d = d2;
        }
        return node;
    }

    public static WaySegment findCandidateSegment(MapView mapView, Way way, Point point) {
        if (mapView == null || way == null || point == null) {
            return null;
        }
        EastNorth eastNorth = mapView.getEastNorth(point.x, point.y);
        Double d = Double.MAX_VALUE;
        Double d2 = 0.0;
        int n = -1;
        List<Pair<Node, Node>> list = way.getNodePairs(true);
        int n2 = -1;
        for (Pair<Node, Node> pair : list) {
            Double d3;
            Double d4;
            ++n2;
            EastNorth eastNorth2 = Geometry.getSegmentAltituteIntersection(((Node)pair.a).getEastNorth(), ((Node)pair.b).getEastNorth(), eastNorth);
            if (eastNorth2 != null) {
                d4 = eastNorth.distance(eastNorth2);
                d3 = Double.MAX_VALUE;
            } else {
                d4 = Math.min(eastNorth.distance(((Node)pair.a).getEastNorth()), eastNorth.distance(((Node)pair.b).getEastNorth()));
                d3 = Math.abs(Geometry.getCornerAngle(((Node)pair.a).getEastNorth(), eastNorth, ((Node)pair.b).getEastNorth()));
            }
            if (!(d4 < d) && (!(d3 > d2) || !(d4 < d * 1.0001))) continue;
            n = n2;
            d2 = d3;
            d = d4;
        }
        return n != -1 ? new WaySegment(way, n) : null;
    }
}

