/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public boolean acceptsUrl(String string) {
        return string != null && (string.matches("http://.*/api/0.6/changeset/\\p{Digit}+/download") || string.matches("http://.*/.*\\.osc"));
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor);
        this.extractOsmFilename("http://.*/(.*\\.osc)", string);
        return Main.worker.submit(this.downloadTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Date> toLoad;

        public HistoryLoaderAndListener(Map<OsmPrimitive, Date> map) {
            this.toLoad = map;
            this.add(map.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet historyDataSet, PrimitiveId primitiveId) {
            HashMap<OsmPrimitive, Date> hashMap = new HashMap<OsmPrimitive, Date>();
            Iterator<OsmPrimitive> iterator = this.toLoad.keySet().iterator();
            while (iterator.hasNext()) {
                HistoryOsmPrimitive historyOsmPrimitive;
                OsmPrimitive osmPrimitive = iterator.next();
                History history = historyDataSet.getHistory(osmPrimitive.getPrimitiveId());
                Date date = this.toLoad.get(osmPrimitive);
                if (history == null || date == null || (historyOsmPrimitive = history.getByDate(date)) == null) continue;
                PrimitiveData primitiveData = null;
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        primitiveData = new NodeData();
                        ((NodeData)primitiveData).setCoor(((HistoryNode)historyOsmPrimitive).getCoords());
                        break;
                    }
                    case WAY: {
                        primitiveData = new WayData();
                        List<Long> list = ((HistoryWay)historyOsmPrimitive).getNodes();
                        ((WayData)primitiveData).setNodes(list);
                        for (Long l : list) {
                            if (osmPrimitive.getDataSet().getPrimitiveById(l, OsmPrimitiveType.NODE) != null) continue;
                            Node node = new Node(l);
                            osmPrimitive.getDataSet().addPrimitive(node);
                            hashMap.put(node, date);
                        }
                        break;
                    }
                    case RELATION: {
                        primitiveData = new RelationData();
                        List<RelationMemberData> list = ((HistoryRelation)historyOsmPrimitive).getMembers();
                        ((RelationData)primitiveData).setMembers(list);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                primitiveData.setUser(historyOsmPrimitive.getUser());
                try {
                    primitiveData.setVisible(historyOsmPrimitive.isVisible());
                }
                catch (IllegalStateException illegalStateException) {
                    System.err.println("Cannot change visibility for " + osmPrimitive + ": " + illegalStateException.getMessage());
                }
                primitiveData.setTimestamp(historyOsmPrimitive.getTimestamp());
                primitiveData.setKeys(historyOsmPrimitive.getTags());
                primitiveData.setOsmId(historyOsmPrimitive.getChangesetId(), (int)historyOsmPrimitive.getVersion());
                try {
                    osmPrimitive.load(primitiveData);
                    iterator.remove();
                }
                catch (AssertionError assertionError) {
                    System.err.println("Cannot load " + osmPrimitive + ": " + ((Throwable)((Object)assertionError)).getMessage());
                }
            }
            historyDataSet.removeHistoryDataSetListener(this);
            if (hashMap.isEmpty()) {
                Main.map.repaint();
            } else {
                Main.worker.submit(new HistoryLoaderAndListener(hashMap));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet historyDataSet) {
        }
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(bl, osmServerReader, progressMonitor);
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                HashMap<OsmPrimitive, Date> hashMap = new HashMap<OsmPrimitive, Date>();
                for (OsmPrimitive osmPrimitive : DownloadOsmChangeTask.this.downloadedData.allNonDeletedPrimitives()) {
                    if (!osmPrimitive.isIncomplete()) continue;
                    Date date = null;
                    for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                        if (osmPrimitive2.isTimestampEmpty()) continue;
                        date = osmPrimitive2.getTimestamp();
                        break;
                    }
                    hashMap.put(osmPrimitive, date);
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                Main.worker.submit(new HistoryLoaderAndListener(hashMap));
            }
            catch (Exception exception) {
                DownloadOsmChangeTask.this.rememberException(exception);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }
}

