/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoader;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import sun.misc.BASE64Decoder;

public class SVGUniverse
implements Serializable {
    public static final long serialVersionUID = 0L;
    private transient PropertyChangeSupport changes = new PropertyChangeSupport(this);
    final HashMap loadedDocs = new HashMap();
    final HashMap loadedFonts = new HashMap();
    final HashMap loadedImages = new HashMap();
    public static final String INPUTSTREAM_SCHEME = "svgSalamander";
    protected double curTime = 0.0;
    private boolean verbose = false;
    XMLReader cachedReader;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void clear() {
        this.loadedDocs.clear();
        this.loadedFonts.clear();
        this.loadedImages.clear();
    }

    public double getCurTime() {
        return this.curTime;
    }

    public void setCurTime(double d) {
        double d2 = this.curTime;
        this.curTime = d;
        this.changes.firePropertyChange("curTime", new Double(d2), new Double(d));
    }

    public void updateTime() throws SVGException {
        for (SVGDiagram sVGDiagram : this.loadedDocs.values()) {
            sVGDiagram.updateTime(this.curTime);
        }
    }

    void registerFont(Font font) {
        this.loadedFonts.put(font.getFontFace().getFontFamily(), font);
    }

    public Font getDefaultFont() {
        Iterator iterator = this.loadedFonts.values().iterator();
        if (iterator.hasNext()) {
            return (Font)iterator.next();
        }
        return null;
    }

    public Font getFont(String string) {
        return (Font)this.loadedFonts.get(string);
    }

    URL registerImage(URI uRI) {
        String string = uRI.getScheme();
        if (string.equals("data")) {
            String string2 = uRI.getRawSchemeSpecificPart();
            int n = string2.indexOf(59);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string4.startsWith("base64")) {
                string4 = string4.substring(6);
                try {
                    URL uRL;
                    byte[] byArray = new BASE64Decoder().decodeBuffer(string4);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                    int n2 = 0;
                    while (this.loadedImages.containsKey(uRL = new URL("inlineImage", "localhost", "img" + n2))) {
                        ++n2;
                    }
                    SoftReference<BufferedImage> softReference = new SoftReference<BufferedImage>(bufferedImage);
                    this.loadedImages.put(uRL, softReference);
                    return uRL;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return null;
        }
        try {
            URL uRL = uRI.toURL();
            this.registerImage(uRL);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    void registerImage(URL uRL) {
        if (this.loadedImages.containsKey(uRL)) {
            return;
        }
        try {
            SoftReference<BufferedImage> softReference;
            String string = uRL.getFile();
            if (".svg".equals(string.substring(string.length() - 4).toLowerCase())) {
                SVGIcon sVGIcon = new SVGIcon();
                sVGIcon.setSvgURI(uRL.toURI());
                BufferedImage bufferedImage = new BufferedImage(sVGIcon.getIconWidth(), sVGIcon.getIconHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                sVGIcon.paintIcon(null, graphics2D, 0, 0);
                graphics2D.dispose();
                softReference = new SoftReference<BufferedImage>(bufferedImage);
            } else {
                BufferedImage bufferedImage = ImageIO.read(uRL);
                softReference = new SoftReference<BufferedImage>(bufferedImage);
            }
            this.loadedImages.put(uRL, softReference);
        }
        catch (Exception exception) {
            System.err.println("Could not load image: " + uRL);
            exception.printStackTrace();
        }
    }

    BufferedImage getImage(URL uRL) {
        SoftReference<BufferedImage> softReference = (SoftReference<BufferedImage>)this.loadedImages.get(uRL);
        if (softReference == null) {
            return null;
        }
        BufferedImage bufferedImage = (BufferedImage)softReference.get();
        if (bufferedImage == null) {
            try {
                bufferedImage = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            softReference = new SoftReference<BufferedImage>(bufferedImage);
            this.loadedImages.put(uRL, softReference);
        }
        return bufferedImage;
    }

    public SVGElement getElement(URI uRI) {
        return this.getElement(uRI, true);
    }

    public SVGElement getElement(URL uRL) {
        try {
            URI uRI = new URI(uRL.toString());
            return this.getElement(uRI, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public SVGElement getElement(URI uRI, boolean bl) {
        try {
            Object object;
            URI uRI2 = new URI(uRI.getScheme(), uRI.getSchemeSpecificPart(), null);
            SVGDiagram sVGDiagram = (SVGDiagram)this.loadedDocs.get(uRI2);
            if (sVGDiagram == null && bl) {
                object = uRI2.toURL();
                this.loadSVG((URL)object, false);
                sVGDiagram = (SVGDiagram)this.loadedDocs.get(uRI2);
                if (sVGDiagram == null) {
                    return null;
                }
            }
            return (object = uRI.getFragment()) == null ? sVGDiagram.getRoot() : sVGDiagram.getElement((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public SVGDiagram getDiagram(URI uRI) {
        return this.getDiagram(uRI, true);
    }

    public SVGDiagram getDiagram(URI uRI, boolean bl) {
        if (uRI == null) {
            return null;
        }
        SVGDiagram sVGDiagram = (SVGDiagram)this.loadedDocs.get(uRI);
        if (sVGDiagram != null || !bl) {
            return sVGDiagram;
        }
        try {
            URL uRL = "jar".equals(uRI.getScheme()) && uRI.getPath() != null && !uRI.getPath().contains("!/") ? SVGUniverse.class.getResource("xmlBase.getPath()") : uRI.toURL();
            this.loadSVG(uRL, false);
            sVGDiagram = (SVGDiagram)this.loadedDocs.get(uRI);
            return sVGDiagram;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private InputStream createDocumentInputStream(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(2);
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        bufferedInputStream.reset();
        if ((n2 << 8 | n) == 35615) {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            return gZIPInputStream;
        }
        return bufferedInputStream;
    }

    public URI loadSVG(URL uRL) {
        return this.loadSVG(uRL, false);
    }

    public URI loadSVG(URL uRL, boolean bl) {
        try {
            URI uRI = new URI(uRL.toString());
            if (this.loadedDocs.containsKey(uRI) && !bl) {
                return uRI;
            }
            InputStream inputStream = uRL.openStream();
            return this.loadSVG(uRI, new InputSource(this.createDocumentInputStream(inputStream)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public URI loadSVG(InputStream inputStream, String string) throws IOException {
        return this.loadSVG(inputStream, string, false);
    }

    public URI loadSVG(InputStream inputStream, String string, boolean bl) throws IOException {
        URI uRI = this.getStreamBuiltURI(string);
        if (uRI == null) {
            return null;
        }
        if (this.loadedDocs.containsKey(uRI) && !bl) {
            return uRI;
        }
        return this.loadSVG(uRI, new InputSource(this.createDocumentInputStream(inputStream)));
    }

    public URI loadSVG(Reader reader, String string) {
        return this.loadSVG(reader, string, false);
    }

    public URI loadSVG(Reader reader, String string, boolean bl) {
        URI uRI = this.getStreamBuiltURI(string);
        if (uRI == null) {
            return null;
        }
        if (this.loadedDocs.containsKey(uRI) && !bl) {
            return uRI;
        }
        return this.loadSVG(uRI, new InputSource(reader));
    }

    public URI getStreamBuiltURI(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new URI(INPUTSTREAM_SCHEME, string, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private XMLReader getXMLReaderCached() throws SAXException {
        if (this.cachedReader == null) {
            this.cachedReader = XMLReaderFactory.createXMLReader();
        }
        return this.cachedReader;
    }

    protected URI loadSVG(URI uRI, InputSource inputSource) {
        SVGLoader sVGLoader = new SVGLoader(uRI, this, this.verbose);
        this.loadedDocs.put(uRI, sVGLoader.getLoadedDiagram());
        try {
            XMLReader xMLReader = this.getXMLReaderCached();
            xMLReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            xMLReader.setContentHandler(sVGLoader);
            xMLReader.parse(inputSource);
            return uRI;
        }
        catch (SAXParseException sAXParseException) {
            System.err.println("Error processing " + uRI);
            System.err.println(sAXParseException.getMessage());
            this.loadedDocs.remove(uRI);
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            URL uRL = new URL(INPUTSTREAM_SCHEME, "localhost", -1, "abc.svg", new URLStreamHandler(){

                protected URLConnection openConnection(URL uRL) {
                    return null;
                }
            });
            URI uRI = new URI(INPUTSTREAM_SCHEME, "/names/mySpecialName", null);
            System.err.println(uRI.toString());
            System.err.println(uRI.getScheme());
            URI uRI2 = uRI.resolve("#begin");
            System.err.println(uRI2.toString());
            URI uRI3 = uRI.resolve("tree#boing");
            System.err.println(uRI3.toString());
            uRI3 = uRI.resolve("../tree#boing");
            System.err.println(uRI3.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public SVGUniverse duplicate() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        SVGUniverse sVGUniverse = (SVGUniverse)objectInputStream.readObject();
        objectInputStream.close();
        return sVGUniverse;
    }
}

