/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.io.imagery.OffsetServer;
import org.openstreetmap.josm.tools.I18n;

public class OsmosnimkiOffsetServer
implements OffsetServer {
    public static final StringProperty PROP_SERVER_URL = new StringProperty("imagery.offsetserver.url", "http://offset.osmosnimki.ru/offset/v0?");
    private String url;

    public OsmosnimkiOffsetServer(String string) {
        this.url = string;
    }

    public boolean isLayerSupported(ImageryInfo imageryInfo) {
        try {
            URL uRL = new URL(this.url + "action=CheckAvailability&id=" + URLEncoder.encode(imageryInfo.getUrl(), "UTF-8"));
            System.out.println(I18n.tr("Querying offset availability: {0}", uRL));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream(), "UTF-8"));
            String string = bufferedReader.readLine();
            System.out.println(I18n.tr("Offset server response: {0}", string));
            if (string == null) {
                return false;
            }
            if (string.contains("\"offsets_available\": true")) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public EastNorth getOffset(ImageryInfo imageryInfo, EastNorth eastNorth) {
        LatLon latLon = Main.getProjection().eastNorth2latlon(eastNorth);
        try {
            URL uRL = new URL(this.url + "action=GetOffsetForPoint&lat=" + latLon.lat() + "&lon=" + latLon.lon() + "&id=" + URLEncoder.encode(imageryInfo.getUrl(), "UTF-8"));
            System.out.println(I18n.tr("Querying offset: {0}", uRL.toString()));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openConnection().getInputStream(), "UTF-8"));
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            int n = string.indexOf(44);
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            return Main.getProjection().latlon2eastNorth(new LatLon(Double.valueOf(string3), Double.valueOf(string2))).sub(eastNorth);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

