/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public NMEAImporter() {
        super(new ExtensionFileFilter("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files", new Object[0]) + " (*.nmea *.nme *.nma *.log *.txt)"));
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        final String string = file.getName();
        final NmeaReader nmeaReader = new NmeaReader(new FileInputStream(file), file.getAbsoluteFile().getParentFile());
        if (nmeaReader.getNumberOfCoordinates() > 0) {
            nmeaReader.data.storageFile = file;
            final GpxLayer gpxLayer = new GpxLayer(nmeaReader.data, string, true);
            final File file2 = file;
            Runnable runnable = new Runnable(){

                public void run() {
                    Main.main.addLayer(gpxLayer);
                    if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                        MarkerLayer markerLayer = new MarkerLayer(nmeaReader.data, I18n.tr("Markers from {0}", string), file2, gpxLayer);
                        if (markerLayer.data.size() > 0) {
                            Main.main.addLayer(markerLayer);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        this.showNmeaInfobox(nmeaReader.getNumberOfCoordinates() > 0, nmeaReader);
    }

    private void showNmeaInfobox(boolean bl, NmeaReader nmeaReader) {
        StringBuilder stringBuilder = new StringBuilder().append("<html>");
        stringBuilder.append(I18n.tr("Coordinates imported: {0}", nmeaReader.getNumberOfCoordinates()) + "<br>");
        stringBuilder.append(I18n.tr("Malformed sentences: {0}", nmeaReader.getParserMalformed()) + "<br>");
        stringBuilder.append(I18n.tr("Checksum errors: {0}", nmeaReader.getParserChecksumErrors()) + "<br>");
        if (!bl) {
            stringBuilder.append(I18n.tr("Unknown sentences: {0}", nmeaReader.getParserUnknown()) + "<br>");
        }
        stringBuilder.append(I18n.tr("Zero coordinates: {0}", nmeaReader.getParserZeroCoordinates()));
        stringBuilder.append("</html>");
        if (bl) {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuilder.toString(), I18n.tr("NMEA import success", new Object[0]), 1, null);
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuilder.toString(), I18n.tr("NMEA import failure!", new Object[0]), 0, null);
        }
    }
}

