/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class MirroredInputStream
extends InputStream {
    InputStream fs = null;
    File file = null;
    public static final long DEFAULT_MAXTIME = -1L;

    public MirroredInputStream(String string) throws IOException {
        this(string, null, -1L);
    }

    public MirroredInputStream(String string, long l) throws IOException {
        this(string, null, l);
    }

    public MirroredInputStream(String string, String string2) throws IOException {
        this(string, string2, -1L);
    }

    public MirroredInputStream(String string, String string2, long l) throws IOException {
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                this.file = new File(string.substring("file:/".length()));
                if (!this.file.exists()) {
                    this.file = new File(string.substring("file://".length()));
                }
            } else if (Main.applet) {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                uRLConnection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
                this.fs = new BufferedInputStream(uRLConnection.getInputStream());
                this.file = new File(uRL.getFile());
            } else {
                this.file = this.checkLocal(uRL, string2, l);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (string.startsWith("resource://")) {
                this.fs = this.getClass().getResourceAsStream(string.substring("resource:/".length()));
                if (this.fs == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", string));
                }
                return;
            }
            this.file = new File(string);
        }
        if (this.file == null) {
            throw new IOException();
        }
        this.fs = new FileInputStream(this.file);
    }

    public InputStream getZipEntry(String string, String string2) {
        InputStream inputStream;
        block6: {
            if (this.file == null) {
                return null;
            }
            inputStream = null;
            try {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry zipEntry = null;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry2 = enumeration.nextElement();
                    if (!zipEntry2.getName().endsWith("." + string) || zipEntry != null && zipEntry2.getName().indexOf(string2) < 0) continue;
                    zipEntry = zipEntry2;
                }
                if (zipEntry != null) {
                    inputStream = zipFile.getInputStream(zipEntry);
                } else {
                    zipFile.close();
                }
            }
            catch (Exception exception) {
                if (!this.file.getName().endsWith(".zip")) break block6;
                System.err.println(I18n.tr("Warning: failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", this.file.getName(), exception.toString(), string, string2));
            }
        }
        return inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public static void cleanup(String string) {
        MirroredInputStream.cleanup(string, null);
    }

    public static void cleanup(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("file")) {
                File file;
                String string3 = MirroredInputStream.getPrefKey(uRL, string2);
                ArrayList<String> arrayList = new ArrayList<String>(Main.pref.getCollection(string3));
                if (arrayList.size() == 2 && (file = new File((String)arrayList.get(1))).exists()) {
                    file.delete();
                }
                Main.pref.putCollection(string3, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static String getPrefKey(URL uRL, String string) {
        StringBuilder stringBuilder = new StringBuilder("mirror.");
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(".");
        }
        stringBuilder.append(uRL.toString());
        return stringBuilder.toString().replaceAll("=", "_");
    }

    private File checkLocal(URL uRL, String string, long l) throws IOException {
        BufferedInputStream bufferedInputStream;
        BufferedOutputStream bufferedOutputStream;
        File file;
        block14: {
            File file2;
            String string2 = MirroredInputStream.getPrefKey(uRL, string);
            long l2 = 0L;
            file = null;
            ArrayList<String> arrayList = new ArrayList<String>(Main.pref.getCollection(string2));
            if (arrayList.size() == 2) {
                file = new File((String)arrayList.get(1));
                if (!file.exists()) {
                    file = null;
                } else {
                    if (l == -1L || l <= 0L) {
                        l = Main.pref.getInteger("mirror.maxtime", 604800);
                    }
                    if ((l2 = System.currentTimeMillis() - Long.parseLong((String)arrayList.get(0))) < l * 1000L) {
                        return file;
                    }
                }
            }
            if (string == null) {
                string = Main.pref.getCacheDirectory().getPath();
            }
            if (!(file2 = new File(string)).exists()) {
                file2.mkdirs();
            }
            String string3 = uRL.toString().replaceAll("[^A-Za-z0-9_.-]", "_");
            String string4 = "mirror_" + string3;
            file2 = new File(string, string4 + ".tmp");
            bufferedOutputStream = null;
            bufferedInputStream = null;
            try {
                int n;
                HttpURLConnection httpURLConnection = this.connectFollowingRedirect(uRL);
                bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                byte[] byArray = new byte[4096];
                while ((n = bufferedInputStream.read(byArray)) > -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.close();
                bufferedOutputStream = null;
                fileOutputStream.close();
                fileOutputStream = null;
                file = new File(string, string4);
                if (Main.platform.rename(file2, file)) {
                    Main.pref.putCollection(string2, Arrays.asList(Long.toString(System.currentTimeMillis()), file.toString()));
                    break block14;
                }
                System.out.println(I18n.tr("Failed to rename file {0} to {1}.", file2.getPath(), file.getPath()));
            }
            catch (IOException iOException) {
                block15: {
                    File file3;
                    try {
                        if (l2 < l * 1000L || l2 >= l * 1000L * 2L) break block15;
                        System.out.println(I18n.tr("Failed to load {0}, use cached file and retry next time: {1}", uRL, iOException));
                        file3 = file;
                    }
                    catch (Throwable throwable) {
                        Utils.close(bufferedInputStream);
                        Utils.close(bufferedOutputStream);
                        throw throwable;
                    }
                    Utils.close(bufferedInputStream);
                    Utils.close(bufferedOutputStream);
                    return file3;
                }
                throw iOException;
            }
        }
        Utils.close(bufferedInputStream);
        Utils.close(bufferedOutputStream);
        return file;
    }

    protected HttpURLConnection connectFollowingRedirect(URL uRL) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = null;
        int n = 0;
        block4: while (true) {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
            httpURLConnection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
            httpURLConnection.connect();
            switch (httpURLConnection.getResponseCode()) {
                case 200: {
                    return httpURLConnection;
                }
                case 301: 
                case 302: 
                case 303: {
                    String string = httpURLConnection.getHeaderField("Location");
                    if (uRL == null) {
                        String string2 = I18n.tr("Unexpected response from HTTP server. Got {0} response without ''Location'' header. Can''t redirect. Aborting.", httpURLConnection.getResponseCode());
                        throw new IOException(string2);
                    }
                    uRL = new URL(string);
                    if (++n >= Main.pref.getInteger("socket.maxredirects", 5)) {
                        String string3 = I18n.tr("Too many redirects to the download URL detected. Aborting.", new Object[0]);
                        throw new IOException(string3);
                    }
                    System.out.println(I18n.tr("Download redirected to ''{0}''", uRL));
                    continue block4;
                }
            }
            break;
        }
        String string = I18n.tr("Failed to read from ''{0}''. Server responded with status code {1}.", uRL, httpURLConnection.getResponseCode());
        throw new IOException(string);
    }

    public int available() throws IOException {
        return this.fs.available();
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public int read() throws IOException {
        return this.fs.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fs.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fs.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.fs.skip(l);
    }
}

