/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.imagery.OffsetServer;
import org.openstreetmap.josm.io.imagery.OsmosnimkiOffsetServer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class ImageryLayer
extends Layer {
    protected static final Icon icon = ImageProvider.get("imagery_small");
    public static final IntegerProperty PROP_FADE_AMOUNT = new IntegerProperty("imagery.fade_amount", 0);
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    protected final ImageryInfo info;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected int sharpenLevel;
    protected boolean offsetServerSupported;
    protected boolean offsetServerUsed;
    protected OffsetServerThread offsetServerThread;
    ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);
    AbstractAction useServerOffsetAction = new AbstractAction(I18n.tr("(use server offset)", new Object[0])){

        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayer.this.enableOffsetServer(true);
        }
    };

    public static Color getFadeColor() {
        return Main.pref.getColor(I18n.marktr("Imagery fade"), Color.white);
    }

    public static Color getFadeColorWithAlpha() {
        Color color = ImageryLayer.getFadeColor();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), PROP_FADE_AMOUNT.get() * 255 / 100);
    }

    public static void setFadeColor(Color color) {
        Main.pref.putColor(I18n.marktr("Imagery fade"), color);
    }

    protected OffsetServerThread createoffsetServerThread() {
        return new OffsetServerThread(new OsmosnimkiOffsetServer(OsmosnimkiOffsetServer.PROP_SERVER_URL.get()));
    }

    public ImageryLayer(ImageryInfo imageryInfo) {
        super(imageryInfo.getName());
        this.info = imageryInfo;
        this.sharpenLevel = PROP_SHARPEN_LEVEL.get();
        if (OffsetServer.PROP_SERVER_ENABLED.get()) {
            this.offsetServerThread = this.createoffsetServerThread();
            this.offsetServerThread.start();
        }
    }

    public double getPPD() {
        if (Main.map == null || Main.map.mapView == null) {
            return Main.getProjection().getDefaultZoomInPPD();
        }
        ProjectionBounds projectionBounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (projectionBounds.maxEast - projectionBounds.minEast);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double d, double d2) {
        this.dx = d;
        this.dy = d2;
    }

    public void displace(double d, double d2) {
        this.setOffset(this.dx += d, this.dy += d2);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    public Icon getIcon() {
        return icon;
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void mergeFrom(Layer layer) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static ImageryLayer create(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS || imageryInfo.getImageryType() == ImageryInfo.ImageryType.HTML) {
            return new WMSLayer(imageryInfo);
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.TMS || imageryInfo.getImageryType() == ImageryInfo.ImageryType.BING || imageryInfo.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new TMSLayer(imageryInfo);
        }
        throw new AssertionError();
    }

    public void enableOffsetServer(boolean bl) {
        this.offsetServerUsed = bl;
        if (this.offsetServerUsed && !this.offsetServerThread.isAlive()) {
            this.offsetServerThread = this.createoffsetServerThread();
            this.offsetServerThread.start();
        }
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset"));
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(jMenu);
    }

    public JComponent getOffsetMenuItem(JComponent jComponent) {
        JMenuItem jMenuItem = new JMenuItem(this.adjustAction);
        if (OffsetBookmark.allBookmarks.isEmpty() && !this.offsetServerSupported) {
            return jMenuItem;
        }
        jComponent.add(jMenuItem);
        if (this.offsetServerSupported) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.useServerOffsetAction);
            if (this.offsetServerUsed) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jComponent.add(jCheckBoxMenuItem);
        }
        jComponent.add(new JSeparator());
        boolean bl = false;
        int n = 0;
        for (OffsetBookmark offsetBookmark : OffsetBookmark.allBookmarks) {
            if (!offsetBookmark.isUsable(this)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ApplyOffsetAction(offsetBookmark));
            if (offsetBookmark.dx == this.dx && offsetBookmark.dy == this.dy && !this.offsetServerUsed) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jComponent.add(jCheckBoxMenuItem);
            n = jCheckBoxMenuItem.getPreferredSize().height;
            bl = true;
        }
        if (n > 0) {
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height / n - 1;
            if (jComponent instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)jComponent, n2);
            } else if (jComponent instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)jComponent, n2);
            }
        }
        return bl || this.offsetServerSupported ? jComponent : jMenuItem;
    }

    public BufferedImage sharpenImage(BufferedImage bufferedImage) {
        if (this.sharpenLevel <= 0) {
            return bufferedImage;
        }
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        Kernel kernel = this.sharpenLevel == 1 ? new Kernel(3, 3, new float[]{-0.25f, -0.5f, -0.25f, -0.5f, 4.0f, -0.5f, -0.25f, -0.5f, -0.25f}) : new Kernel(3, 3, new float[]{-0.5f, -1.0f, -0.5f, -1.0f, 7.0f, -1.0f, -0.5f, -1.0f, -0.5f});
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
        return convolveOp.filter(bufferedImage2, null);
    }

    public void drawErrorTile(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.RED);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setFont(graphics.getFont().deriveFont(0).deriveFont(36.0f));
        graphics.setColor(Color.BLACK);
        String string = I18n.tr("ERROR", new Object[0]);
        graphics.drawString(string, (bufferedImage.getWidth() + graphics.getFontMetrics().stringWidth(string)) / 2, bufferedImage.getHeight() / 2);
    }

    protected class OffsetServerThread
    extends Thread {
        OffsetServer offsetServer;
        EastNorth oldCenter = new EastNorth(Double.NaN, Double.NaN);

        public OffsetServerThread(OffsetServer offsetServer) {
            this.offsetServer = offsetServer;
            this.setDaemon(true);
        }

        private void updateOffset() {
            if (Main.map == null || Main.map.mapView == null) {
                return;
            }
            EastNorth eastNorth = Main.map.mapView.getCenter();
            if (eastNorth.equals(this.oldCenter)) {
                return;
            }
            this.oldCenter = eastNorth;
            EastNorth eastNorth2 = this.offsetServer.getOffset(ImageryLayer.this.getInfo(), eastNorth);
            if (eastNorth2 != null) {
                ImageryLayer.this.setOffset(eastNorth2.east(), eastNorth2.north());
            }
        }

        public void run() {
            if (!ImageryLayer.this.offsetServerSupported) {
                if (!this.offsetServer.isLayerSupported(ImageryLayer.this.info)) {
                    return;
                }
                ImageryLayer.this.offsetServerSupported = true;
            }
            ImageryLayer.this.offsetServerUsed = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.main.menu.imageryMenu.refreshOffsetMenu();
                }
            });
            try {
                while (ImageryLayer.this.offsetServerUsed) {
                    this.updateOffset();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ImageryLayer.this.offsetServerUsed = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark offsetBookmark) {
            super(offsetBookmark.name);
            this.b = offsetBookmark;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            ImageryLayer.this.enableOffsetServer(false);
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            Main.map.repaint();
        }
    }
}

