/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.history.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.history.NodeListTableColumnModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListViewer
extends JPanel {
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private SelectionSynchronizer selectionSynchronizer;
    private NodeListPopupMenu popupMenu;

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    protected JTable buildReferenceNodeListTable() {
        JTable jTable = new JTable(this.model.getNodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new NodeListTableColumnModel());
        jTable.setName("table.referencenodelisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.addMouseListener(new PopupMenuLauncher(jTable));
        jTable.addMouseListener(new DoubleClickAdapter(jTable));
        return jTable;
    }

    protected JTable buildCurrentNodeListTable() {
        JTable jTable = new JTable(this.model.getNodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new NodeListTableColumnModel());
        jTable.setName("table.currentnodelisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.addMouseListener(new PopupMenuLauncher(jTable));
        jTable.addMouseListener(new DoubleClickAdapter(jTable));
        return jTable;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceNodeListTable()), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentNodeListTable()), gridBagConstraints);
        this.popupMenu = new NodeListPopupMenu();
    }

    public NodeListViewer(HistoryBrowserModel historyBrowserModel) {
        this.setModel(historyBrowserModel);
        this.build();
    }

    protected void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    private static PrimitiveId primitiveIdAtRow(TableModel tableModel, int n) {
        DiffTableModel diffTableModel = (DiffTableModel)tableModel;
        Long l = (Long)diffTableModel.getValueAt((int)n, (int)0).value;
        if (l == null) {
            return null;
        }
        return new SimplePrimitiveId(l, OsmPrimitiveType.NODE);
    }

    static class DoubleClickAdapter
    extends MouseAdapter {
        private JTable table;
        private ShowHistoryAction showHistoryAction;

        public DoubleClickAdapter(JTable jTable) {
            this.table = jTable;
            this.showHistoryAction = new ShowHistoryAction();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                return;
            }
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n <= 0) {
                return;
            }
            PrimitiveId primitiveId = NodeListViewer.primitiveIdAtRow(this.table.getModel(), n);
            if (primitiveId == null) {
                return;
            }
            this.showHistoryAction.setPrimitiveId(primitiveId);
            this.showHistoryAction.run();
        }
    }

    class PopupMenuLauncher
    extends MouseAdapter {
        private JTable table;

        public PopupMenuLauncher(JTable jTable) {
            this.table = jTable;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            PrimitiveId primitiveId = NodeListViewer.primitiveIdAtRow(this.table.getModel(), n);
            if (primitiveId == null) {
                return;
            }
            NodeListViewer.this.popupMenu.prepare(primitiveId);
            NodeListViewer.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    static class ShowHistoryAction
    extends AbstractAction {
        private PrimitiveId primitiveId;

        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a history browser with the history of this node", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void setPrimitiveId(PrimitiveId primitiveId) {
            this.primitiveId = primitiveId;
            this.updateEnabledState();
        }

        public void run() {
            if (HistoryDataSet.getInstance().getHistory(this.primitiveId) == null) {
                Main.worker.submit(new HistoryLoadTask().add(this.primitiveId));
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    History history = HistoryDataSet.getInstance().getHistory(ShowHistoryAction.this.primitiveId);
                    if (history == null) {
                        return;
                    }
                    HistoryBrowserDialogManager.getInstance().show(history);
                }
            };
            Main.worker.submit(runnable);
        }

        public void updateEnabledState() {
            this.setEnabled(this.primitiveId != null && this.primitiveId.getUniqueId() > 0L);
        }
    }

    static class ZoomToNodeAction
    extends AbstractAction {
        private PrimitiveId primitiveId;

        public ZoomToNodeAction() {
            this.putValue("Name", I18n.tr("Zoom to node", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to this node in the current data layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "zoomin"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            OsmPrimitive osmPrimitive = this.getPrimitiveToZoom();
            if (osmPrimitive != null) {
                this.getEditLayer().data.setSelected(osmPrimitive.getPrimitiveId());
                AutoScaleAction.autoScale("selection");
            }
        }

        public void setPrimitiveId(PrimitiveId primitiveId) {
            this.primitiveId = primitiveId;
            this.updateEnabledState();
        }

        protected OsmDataLayer getEditLayer() {
            try {
                return Main.map.mapView.getEditLayer();
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }

        protected OsmPrimitive getPrimitiveToZoom() {
            if (this.primitiveId == null) {
                return null;
            }
            OsmPrimitive osmPrimitive = this.getEditLayer().data.getPrimitiveById(this.primitiveId);
            return osmPrimitive;
        }

        public void updateEnabledState() {
            if (this.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.getPrimitiveToZoom() != null);
        }
    }

    static class NodeListPopupMenu
    extends JPopupMenu {
        private ZoomToNodeAction zoomToNodeAction = new ZoomToNodeAction();
        private ShowHistoryAction showHistoryAction;

        public NodeListPopupMenu() {
            this.add(this.zoomToNodeAction);
            this.showHistoryAction = new ShowHistoryAction();
            this.add(this.showHistoryAction);
        }

        public void prepare(PrimitiveId primitiveId) {
            this.zoomToNodeAction.setPrimitiveId(primitiveId);
            this.zoomToNodeAction.updateEnabledState();
            this.showHistoryAction.setPrimitiveId(primitiveId);
            this.showHistoryAction.updateEnabledState();
        }
    }
}

