/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class BelgianLambert1972
extends AbstractProjection {
    public BelgianLambert1972() {
        this.ellps = Ellipsoid.hayford;
        this.datum = new SevenParameterDatum("Belgium Datum 72", null, this.ellps, -99.06, 53.32, -112.49, 0.419, -0.83, 1.885, -1.0);
        this.x_0 = 150000.013;
        this.y_0 = 5400088.438;
        this.lon_0 = BelgianLambert1972.convertDegreeMinuteSecond(4.0, 22.0, 2.952);
        this.proj = new LambertConformalConic();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = BelgianLambert1972.this.ellps;
                    this.lat_0 = 90.0;
                    this.lat_1 = 49.0 + AbstractProjection.convertMinuteSecond(50.0, 0.00204);
                    this.lat_2 = 51.0 + AbstractProjection.convertMinuteSecond(10.0, 0.00204);
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    public String getCacheDirectoryName() {
        return "belgianLambert1972";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(49.51, 2.54), new LatLon(51.5, 6.4), false);
    }

    public Integer getEpsgCode() {
        return 31370;
    }

    public String toString() {
        return I18n.tr("Belgian Lambert 1972", new Object[0]);
    }
}

