/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> collection) throws SearchCompiler.ParseError {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
        for (Filter filter : collection) {
            if (!filter.enable) continue;
            FilterInfo filterInfo = new FilterInfo(filter);
            if (filterInfo.isDelete) {
                if (filter.hiding) {
                    this.hiddenFilters.add(filterInfo);
                    continue;
                }
                this.disabledFilters.add(filterInfo);
                this.hiddenFilters.add(filterInfo);
                continue;
            }
            if (filter.mode == SearchAction.SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(filterInfo);
            if (!filter.hiding) continue;
            this.hiddenFilters.add(filterInfo);
        }
    }

    private boolean getState(OsmPrimitive osmPrimitive, boolean bl) {
        return bl ? osmPrimitive.isDisabledAndHidden() : osmPrimitive.isDisabled();
    }

    private boolean allParentWaysFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way)) continue;
            bl2 = true;
            if (this.getState(osmPrimitive2, bl)) continue;
            return false;
        }
        return bl2;
    }

    private boolean oneParentWayNotFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way) || this.getState(osmPrimitive2, bl)) continue;
            return true;
        }
        return false;
    }

    private boolean test(List<FilterInfo> list, OsmPrimitive osmPrimitive, boolean bl) {
        if (osmPrimitive.isIncomplete()) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = true;
        for (FilterInfo filterInfo : list) {
            if (filterInfo.isDelete && bl2 && filterInfo.match.match(osmPrimitive)) {
                bl2 = false;
                continue;
            }
            if (filterInfo.isDelete || bl2 && (!bl3 || filterInfo.isInverted) || !filterInfo.match.match(osmPrimitive)) continue;
            bl2 = true;
            bl3 = bl3 && filterInfo.isInverted;
        }
        if (osmPrimitive instanceof Node) {
            if (!bl2) {
                return !osmPrimitive.isTagged() && this.allParentWaysFiltered(osmPrimitive, bl);
            }
            if (bl3) {
                return bl2 && !this.oneParentWayNotFiltered(osmPrimitive, bl);
            }
            return true;
        }
        return bl2;
    }

    public boolean isHidden(OsmPrimitive osmPrimitive) {
        return this.test(this.hiddenFilters, osmPrimitive, true);
    }

    public boolean isDisabled(OsmPrimitive osmPrimitive) {
        return this.test(this.disabledFilters, osmPrimitive, false);
    }

    private static class FilterInfo {
        final SearchCompiler.Match match;
        final boolean isDelete;
        final boolean isInverted;

        FilterInfo(Filter filter) throws SearchCompiler.ParseError {
            this.isDelete = filter.mode == SearchAction.SearchMode.remove || filter.mode == SearchAction.SearchMode.in_selection;
            SearchCompiler.Match match = SearchCompiler.compile(filter.text, filter.caseSensitive, filter.regexSearch);
            this.match = filter.inverted ? new SearchCompiler.Not(match) : match;
            this.isInverted = filter.inverted;
        }
    }
}

